package zio.aws.dataexchange.model
import java.lang.Integer
import zio.aws.dataexchange.model.primitives.{__string, MaxResults}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListDataSetsRequest(
    maxResults: Option[MaxResults] = None,
    nextToken: Option[__string] = None,
    origin: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dataexchange.model.ListDataSetsRequest = {
    import ListDataSetsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dataexchange.model.ListDataSetsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(origin.map(value => value: java.lang.String))(_.origin)
      .build()
  }
  def asReadOnly: zio.aws.dataexchange.model.ListDataSetsRequest.ReadOnly =
    zio.aws.dataexchange.model.ListDataSetsRequest.wrap(buildAwsValue())
}
object ListDataSetsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dataexchange.model.ListDataSetsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dataexchange.model.ListDataSetsRequest =
      zio.aws.dataexchange.model.ListDataSetsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        origin.map(value => value)
      )
    def maxResults: Option[MaxResults]
    def nextToken: Option[__string]
    def origin: Option[__string]
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getOrigin: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("origin", origin)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dataexchange.model.ListDataSetsRequest
  ) extends zio.aws.dataexchange.model.ListDataSetsRequest.ReadOnly {
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.dataexchange.model.primitives.MaxResults(value))
    override val nextToken: Option[__string] =
      scala.Option(impl.nextToken()).map(value => value: __string)
    override val origin: Option[__string] =
      scala.Option(impl.origin()).map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.dataexchange.model.ListDataSetsRequest
  ): zio.aws.dataexchange.model.ListDataSetsRequest.ReadOnly = new Wrapper(impl)
}
