package zio.aws.dataexchange.model
import zio.aws.dataexchange.model.primitives.{Id, Timestamp, Arn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class JobEntry(
    arn: Arn,
    createdAt: Timestamp,
    details: zio.aws.dataexchange.model.ResponseDetails,
    errors: Option[Iterable[zio.aws.dataexchange.model.JobError]] = None,
    id: Id,
    state: zio.aws.dataexchange.model.State,
    `type`: zio.aws.dataexchange.model.Type,
    updatedAt: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dataexchange.model.JobEntry = {
    import JobEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dataexchange.model.JobEntry
      .builder()
      .arn(Arn.unwrap(arn): java.lang.String)
      .createdAt(Timestamp.unwrap(createdAt): Instant)
      .details(details.buildAwsValue())
      .optionallyWith(
        errors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.errors)
      .id(Id.unwrap(id): java.lang.String)
      .state(state.unwrap)
      .`type`(`type`.unwrap)
      .updatedAt(Timestamp.unwrap(updatedAt): Instant)
      .build()
  }
  def asReadOnly: zio.aws.dataexchange.model.JobEntry.ReadOnly =
    zio.aws.dataexchange.model.JobEntry.wrap(buildAwsValue())
}
object JobEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dataexchange.model.JobEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dataexchange.model.JobEntry =
      zio.aws.dataexchange.model.JobEntry(
        arn,
        createdAt,
        details.asEditable,
        errors.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        id,
        state,
        `type`,
        updatedAt
      )
    def arn: Arn
    def createdAt: Timestamp
    def details: zio.aws.dataexchange.model.ResponseDetails.ReadOnly
    def errors: Option[List[zio.aws.dataexchange.model.JobError.ReadOnly]]
    def id: Id
    def state: zio.aws.dataexchange.model.State
    def `type`: zio.aws.dataexchange.model.Type
    def updatedAt: Timestamp
    def getArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(arn)
    def getCreatedAt: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(createdAt)
    def getDetails: ZIO[
      Any,
      Nothing,
      zio.aws.dataexchange.model.ResponseDetails.ReadOnly
    ] = ZIO.succeed(details)
    def getErrors: ZIO[Any, AwsError, List[
      zio.aws.dataexchange.model.JobError.ReadOnly
    ]] = AwsError.unwrapOptionField("errors", errors)
    def getId: ZIO[Any, Nothing, Id] = ZIO.succeed(id)
    def getState: ZIO[Any, Nothing, zio.aws.dataexchange.model.State] =
      ZIO.succeed(state)
    def getType: ZIO[Any, Nothing, zio.aws.dataexchange.model.Type] =
      ZIO.succeed(`type`)
    def getUpdatedAt: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(updatedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dataexchange.model.JobEntry
  ) extends zio.aws.dataexchange.model.JobEntry.ReadOnly {
    override val arn: Arn =
      zio.aws.dataexchange.model.primitives.Arn(impl.arn())
    override val createdAt: Timestamp =
      zio.aws.dataexchange.model.primitives.Timestamp(impl.createdAt())
    override val details: zio.aws.dataexchange.model.ResponseDetails.ReadOnly =
      zio.aws.dataexchange.model.ResponseDetails.wrap(impl.details())
    override val errors
        : Option[List[zio.aws.dataexchange.model.JobError.ReadOnly]] = scala
      .Option(impl.errors())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.dataexchange.model.JobError.wrap(item)
        }.toList
      )
    override val id: Id = zio.aws.dataexchange.model.primitives.Id(impl.id())
    override val state: zio.aws.dataexchange.model.State =
      zio.aws.dataexchange.model.State.wrap(impl.state())
    override val `type`: zio.aws.dataexchange.model.Type =
      zio.aws.dataexchange.model.Type.wrap(impl.`type`())
    override val updatedAt: Timestamp =
      zio.aws.dataexchange.model.primitives.Timestamp(impl.updatedAt())
  }
  def wrap(
      impl: software.amazon.awssdk.services.dataexchange.model.JobEntry
  ): zio.aws.dataexchange.model.JobEntry.ReadOnly = new Wrapper(impl)
}
