package zio.aws.dataexchange.model
import zio.aws.dataexchange.model.primitives.Id
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ExportRevisionsToS3RequestDetails(
    dataSetId: Id,
    encryption: Option[zio.aws.dataexchange.model.ExportServerSideEncryption] =
      None,
    revisionDestinations: Iterable[
      zio.aws.dataexchange.model.RevisionDestinationEntry
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dataexchange.model.ExportRevisionsToS3RequestDetails = {
    import ExportRevisionsToS3RequestDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dataexchange.model.ExportRevisionsToS3RequestDetails
      .builder()
      .dataSetId(Id.unwrap(dataSetId): java.lang.String)
      .optionallyWith(encryption.map(value => value.buildAwsValue()))(
        _.encryption
      )
      .revisionDestinations(revisionDestinations.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.dataexchange.model.ExportRevisionsToS3RequestDetails.ReadOnly =
    zio.aws.dataexchange.model.ExportRevisionsToS3RequestDetails
      .wrap(buildAwsValue())
}
object ExportRevisionsToS3RequestDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dataexchange.model.ExportRevisionsToS3RequestDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.dataexchange.model.ExportRevisionsToS3RequestDetails =
      zio.aws.dataexchange.model.ExportRevisionsToS3RequestDetails(
        dataSetId,
        encryption.map(value => value.asEditable),
        revisionDestinations.map { item =>
          item.asEditable
        }
      )
    def dataSetId: Id
    def encryption
        : Option[zio.aws.dataexchange.model.ExportServerSideEncryption.ReadOnly]
    def revisionDestinations
        : List[zio.aws.dataexchange.model.RevisionDestinationEntry.ReadOnly]
    def getDataSetId: ZIO[Any, Nothing, Id] = ZIO.succeed(dataSetId)
    def getEncryption: ZIO[
      Any,
      AwsError,
      zio.aws.dataexchange.model.ExportServerSideEncryption.ReadOnly
    ] = AwsError.unwrapOptionField("encryption", encryption)
    def getRevisionDestinations: ZIO[Any, Nothing, List[
      zio.aws.dataexchange.model.RevisionDestinationEntry.ReadOnly
    ]] = ZIO.succeed(revisionDestinations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dataexchange.model.ExportRevisionsToS3RequestDetails
  ) extends zio.aws.dataexchange.model.ExportRevisionsToS3RequestDetails.ReadOnly {
    override val dataSetId: Id =
      zio.aws.dataexchange.model.primitives.Id(impl.dataSetId())
    override val encryption: Option[
      zio.aws.dataexchange.model.ExportServerSideEncryption.ReadOnly
    ] = scala
      .Option(impl.encryption())
      .map(value =>
        zio.aws.dataexchange.model.ExportServerSideEncryption.wrap(value)
      )
    override val revisionDestinations
        : List[zio.aws.dataexchange.model.RevisionDestinationEntry.ReadOnly] =
      impl
        .revisionDestinations()
        .asScala
        .map { item =>
          zio.aws.dataexchange.model.RevisionDestinationEntry.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.dataexchange.model.ExportRevisionsToS3RequestDetails
  ): zio.aws.dataexchange.model.ExportRevisionsToS3RequestDetails.ReadOnly =
    new Wrapper(impl)
}
