package zio.aws.dataexchange.model
import zio.aws.dataexchange.model.primitives.{
  __boolean,
  __string,
  __stringMin0Max16384
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateRevisionRequest(
    comment: Option[__stringMin0Max16384] = None,
    dataSetId: __string,
    finalized: Option[__boolean] = None,
    revisionId: __string
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dataexchange.model.UpdateRevisionRequest = {
    import UpdateRevisionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dataexchange.model.UpdateRevisionRequest
      .builder()
      .optionallyWith(comment.map(value => value: java.lang.String))(_.comment)
      .dataSetId(dataSetId: java.lang.String)
      .optionallyWith(finalized.map(value => value: java.lang.Boolean))(
        _.finalized
      )
      .revisionId(revisionId: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.dataexchange.model.UpdateRevisionRequest.ReadOnly =
    zio.aws.dataexchange.model.UpdateRevisionRequest.wrap(buildAwsValue())
}
object UpdateRevisionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dataexchange.model.UpdateRevisionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dataexchange.model.UpdateRevisionRequest =
      zio.aws.dataexchange.model.UpdateRevisionRequest(
        comment.map(value => value),
        dataSetId,
        finalized.map(value => value),
        revisionId
      )
    def comment: Option[__stringMin0Max16384]
    def dataSetId: __string
    def finalized: Option[__boolean]
    def revisionId: __string
    def getComment: ZIO[Any, AwsError, __stringMin0Max16384] =
      AwsError.unwrapOptionField("comment", comment)
    def getDataSetId: ZIO[Any, Nothing, __string] = ZIO.succeed(dataSetId)
    def getFinalized: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("finalized", finalized)
    def getRevisionId: ZIO[Any, Nothing, __string] = ZIO.succeed(revisionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dataexchange.model.UpdateRevisionRequest
  ) extends zio.aws.dataexchange.model.UpdateRevisionRequest.ReadOnly {
    override val comment: Option[__stringMin0Max16384] =
      scala.Option(impl.comment()).map(value => value: __stringMin0Max16384)
    override val dataSetId: __string = impl.dataSetId(): __string
    override val finalized: Option[__boolean] =
      scala.Option(impl.finalized()).map(value => value: __boolean)
    override val revisionId: __string = impl.revisionId(): __string
  }
  def wrap(
      impl: software.amazon.awssdk.services.dataexchange.model.UpdateRevisionRequest
  ): zio.aws.dataexchange.model.UpdateRevisionRequest.ReadOnly = new Wrapper(
    impl
  )
}
