package zio.aws.dataexchange.model
import zio.aws.dataexchange.model.primitives.{AssetName, Id, Timestamp, Arn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class UpdateAssetResponse(
    arn: Option[Arn] = None,
    assetDetails: Option[zio.aws.dataexchange.model.AssetDetails] = None,
    assetType: Option[zio.aws.dataexchange.model.AssetType] = None,
    createdAt: Option[Timestamp] = None,
    dataSetId: Option[Id] = None,
    id: Option[Id] = None,
    name: Option[AssetName] = None,
    revisionId: Option[Id] = None,
    sourceId: Option[Id] = None,
    updatedAt: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dataexchange.model.UpdateAssetResponse = {
    import UpdateAssetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dataexchange.model.UpdateAssetResponse
      .builder()
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(assetDetails.map(value => value.buildAwsValue()))(
        _.assetDetails
      )
      .optionallyWith(assetType.map(value => value.unwrap))(_.assetType)
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(
        dataSetId.map(value => Id.unwrap(value): java.lang.String)
      )(_.dataSetId)
      .optionallyWith(id.map(value => Id.unwrap(value): java.lang.String))(_.id)
      .optionallyWith(
        name.map(value => AssetName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        revisionId.map(value => Id.unwrap(value): java.lang.String)
      )(_.revisionId)
      .optionallyWith(
        sourceId.map(value => Id.unwrap(value): java.lang.String)
      )(_.sourceId)
      .optionallyWith(updatedAt.map(value => Timestamp.unwrap(value): Instant))(
        _.updatedAt
      )
      .build()
  }
  def asReadOnly: zio.aws.dataexchange.model.UpdateAssetResponse.ReadOnly =
    zio.aws.dataexchange.model.UpdateAssetResponse.wrap(buildAwsValue())
}
object UpdateAssetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dataexchange.model.UpdateAssetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dataexchange.model.UpdateAssetResponse =
      zio.aws.dataexchange.model.UpdateAssetResponse(
        arn.map(value => value),
        assetDetails.map(value => value.asEditable),
        assetType.map(value => value),
        createdAt.map(value => value),
        dataSetId.map(value => value),
        id.map(value => value),
        name.map(value => value),
        revisionId.map(value => value),
        sourceId.map(value => value),
        updatedAt.map(value => value)
      )
    def arn: Option[Arn]
    def assetDetails: Option[zio.aws.dataexchange.model.AssetDetails.ReadOnly]
    def assetType: Option[zio.aws.dataexchange.model.AssetType]
    def createdAt: Option[Timestamp]
    def dataSetId: Option[Id]
    def id: Option[Id]
    def name: Option[AssetName]
    def revisionId: Option[Id]
    def sourceId: Option[Id]
    def updatedAt: Option[Timestamp]
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
    def getAssetDetails
        : ZIO[Any, AwsError, zio.aws.dataexchange.model.AssetDetails.ReadOnly] =
      AwsError.unwrapOptionField("assetDetails", assetDetails)
    def getAssetType: ZIO[Any, AwsError, zio.aws.dataexchange.model.AssetType] =
      AwsError.unwrapOptionField("assetType", assetType)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getDataSetId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("dataSetId", dataSetId)
    def getId: ZIO[Any, AwsError, Id] = AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, AssetName] =
      AwsError.unwrapOptionField("name", name)
    def getRevisionId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("revisionId", revisionId)
    def getSourceId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("sourceId", sourceId)
    def getUpdatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dataexchange.model.UpdateAssetResponse
  ) extends zio.aws.dataexchange.model.UpdateAssetResponse.ReadOnly {
    override val arn: Option[Arn] = scala
      .Option(impl.arn())
      .map(value => zio.aws.dataexchange.model.primitives.Arn(value))
    override val assetDetails
        : Option[zio.aws.dataexchange.model.AssetDetails.ReadOnly] = scala
      .Option(impl.assetDetails())
      .map(value => zio.aws.dataexchange.model.AssetDetails.wrap(value))
    override val assetType: Option[zio.aws.dataexchange.model.AssetType] = scala
      .Option(impl.assetType())
      .map(value => zio.aws.dataexchange.model.AssetType.wrap(value))
    override val createdAt: Option[Timestamp] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.dataexchange.model.primitives.Timestamp(value))
    override val dataSetId: Option[Id] = scala
      .Option(impl.dataSetId())
      .map(value => zio.aws.dataexchange.model.primitives.Id(value))
    override val id: Option[Id] = scala
      .Option(impl.id())
      .map(value => zio.aws.dataexchange.model.primitives.Id(value))
    override val name: Option[AssetName] = scala
      .Option(impl.name())
      .map(value => zio.aws.dataexchange.model.primitives.AssetName(value))
    override val revisionId: Option[Id] = scala
      .Option(impl.revisionId())
      .map(value => zio.aws.dataexchange.model.primitives.Id(value))
    override val sourceId: Option[Id] = scala
      .Option(impl.sourceId())
      .map(value => zio.aws.dataexchange.model.primitives.Id(value))
    override val updatedAt: Option[Timestamp] = scala
      .Option(impl.updatedAt())
      .map(value => zio.aws.dataexchange.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dataexchange.model.UpdateAssetResponse
  ): zio.aws.dataexchange.model.UpdateAssetResponse.ReadOnly = new Wrapper(impl)
}
