package zio.aws.dataexchange.model
import zio.aws.dataexchange.model.primitives.{
  __stringMin10Max512,
  Timestamp,
  __boolean,
  Arn,
  __stringMin0Max16384,
  Id
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class RevokeRevisionResponse(
    arn: Option[Arn] = None,
    comment: Option[__stringMin0Max16384] = None,
    createdAt: Option[Timestamp] = None,
    dataSetId: Option[Id] = None,
    finalized: Option[__boolean] = None,
    id: Option[Id] = None,
    sourceId: Option[Id] = None,
    updatedAt: Option[Timestamp] = None,
    revocationComment: Option[__stringMin10Max512] = None,
    revoked: Option[__boolean] = None,
    revokedAt: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dataexchange.model.RevokeRevisionResponse = {
    import RevokeRevisionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dataexchange.model.RevokeRevisionResponse
      .builder()
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(comment.map(value => value: java.lang.String))(_.comment)
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(
        dataSetId.map(value => Id.unwrap(value): java.lang.String)
      )(_.dataSetId)
      .optionallyWith(finalized.map(value => value: java.lang.Boolean))(
        _.finalized
      )
      .optionallyWith(id.map(value => Id.unwrap(value): java.lang.String))(_.id)
      .optionallyWith(
        sourceId.map(value => Id.unwrap(value): java.lang.String)
      )(_.sourceId)
      .optionallyWith(updatedAt.map(value => Timestamp.unwrap(value): Instant))(
        _.updatedAt
      )
      .optionallyWith(revocationComment.map(value => value: java.lang.String))(
        _.revocationComment
      )
      .optionallyWith(revoked.map(value => value: java.lang.Boolean))(_.revoked)
      .optionallyWith(revokedAt.map(value => Timestamp.unwrap(value): Instant))(
        _.revokedAt
      )
      .build()
  }
  def asReadOnly: zio.aws.dataexchange.model.RevokeRevisionResponse.ReadOnly =
    zio.aws.dataexchange.model.RevokeRevisionResponse.wrap(buildAwsValue())
}
object RevokeRevisionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dataexchange.model.RevokeRevisionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dataexchange.model.RevokeRevisionResponse =
      zio.aws.dataexchange.model.RevokeRevisionResponse(
        arn.map(value => value),
        comment.map(value => value),
        createdAt.map(value => value),
        dataSetId.map(value => value),
        finalized.map(value => value),
        id.map(value => value),
        sourceId.map(value => value),
        updatedAt.map(value => value),
        revocationComment.map(value => value),
        revoked.map(value => value),
        revokedAt.map(value => value)
      )
    def arn: Option[Arn]
    def comment: Option[__stringMin0Max16384]
    def createdAt: Option[Timestamp]
    def dataSetId: Option[Id]
    def finalized: Option[__boolean]
    def id: Option[Id]
    def sourceId: Option[Id]
    def updatedAt: Option[Timestamp]
    def revocationComment: Option[__stringMin10Max512]
    def revoked: Option[__boolean]
    def revokedAt: Option[Timestamp]
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
    def getComment: ZIO[Any, AwsError, __stringMin0Max16384] =
      AwsError.unwrapOptionField("comment", comment)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getDataSetId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("dataSetId", dataSetId)
    def getFinalized: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("finalized", finalized)
    def getId: ZIO[Any, AwsError, Id] = AwsError.unwrapOptionField("id", id)
    def getSourceId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("sourceId", sourceId)
    def getUpdatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
    def getRevocationComment: ZIO[Any, AwsError, __stringMin10Max512] =
      AwsError.unwrapOptionField("revocationComment", revocationComment)
    def getRevoked: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("revoked", revoked)
    def getRevokedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("revokedAt", revokedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dataexchange.model.RevokeRevisionResponse
  ) extends zio.aws.dataexchange.model.RevokeRevisionResponse.ReadOnly {
    override val arn: Option[Arn] = scala
      .Option(impl.arn())
      .map(value => zio.aws.dataexchange.model.primitives.Arn(value))
    override val comment: Option[__stringMin0Max16384] =
      scala.Option(impl.comment()).map(value => value: __stringMin0Max16384)
    override val createdAt: Option[Timestamp] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.dataexchange.model.primitives.Timestamp(value))
    override val dataSetId: Option[Id] = scala
      .Option(impl.dataSetId())
      .map(value => zio.aws.dataexchange.model.primitives.Id(value))
    override val finalized: Option[__boolean] =
      scala.Option(impl.finalized()).map(value => value: __boolean)
    override val id: Option[Id] = scala
      .Option(impl.id())
      .map(value => zio.aws.dataexchange.model.primitives.Id(value))
    override val sourceId: Option[Id] = scala
      .Option(impl.sourceId())
      .map(value => zio.aws.dataexchange.model.primitives.Id(value))
    override val updatedAt: Option[Timestamp] = scala
      .Option(impl.updatedAt())
      .map(value => zio.aws.dataexchange.model.primitives.Timestamp(value))
    override val revocationComment: Option[__stringMin10Max512] = scala
      .Option(impl.revocationComment())
      .map(value => value: __stringMin10Max512)
    override val revoked: Option[__boolean] =
      scala.Option(impl.revoked()).map(value => value: __boolean)
    override val revokedAt: Option[Timestamp] = scala
      .Option(impl.revokedAt())
      .map(value => zio.aws.dataexchange.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dataexchange.model.RevokeRevisionResponse
  ): zio.aws.dataexchange.model.RevokeRevisionResponse.ReadOnly = new Wrapper(
    impl
  )
}
