package zio.aws.dataexchange.model
import zio.aws.dataexchange.model.primitives.{Id, Timestamp, Arn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class GetEventActionResponse(
    action: Option[zio.aws.dataexchange.model.Action] = None,
    arn: Option[Arn] = None,
    createdAt: Option[Timestamp] = None,
    event: Option[zio.aws.dataexchange.model.Event] = None,
    id: Option[Id] = None,
    updatedAt: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dataexchange.model.GetEventActionResponse = {
    import GetEventActionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dataexchange.model.GetEventActionResponse
      .builder()
      .optionallyWith(action.map(value => value.buildAwsValue()))(_.action)
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(event.map(value => value.buildAwsValue()))(_.event)
      .optionallyWith(id.map(value => Id.unwrap(value): java.lang.String))(_.id)
      .optionallyWith(updatedAt.map(value => Timestamp.unwrap(value): Instant))(
        _.updatedAt
      )
      .build()
  }
  def asReadOnly: zio.aws.dataexchange.model.GetEventActionResponse.ReadOnly =
    zio.aws.dataexchange.model.GetEventActionResponse.wrap(buildAwsValue())
}
object GetEventActionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dataexchange.model.GetEventActionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dataexchange.model.GetEventActionResponse =
      zio.aws.dataexchange.model.GetEventActionResponse(
        action.map(value => value.asEditable),
        arn.map(value => value),
        createdAt.map(value => value),
        event.map(value => value.asEditable),
        id.map(value => value),
        updatedAt.map(value => value)
      )
    def action: Option[zio.aws.dataexchange.model.Action.ReadOnly]
    def arn: Option[Arn]
    def createdAt: Option[Timestamp]
    def event: Option[zio.aws.dataexchange.model.Event.ReadOnly]
    def id: Option[Id]
    def updatedAt: Option[Timestamp]
    def getAction
        : ZIO[Any, AwsError, zio.aws.dataexchange.model.Action.ReadOnly] =
      AwsError.unwrapOptionField("action", action)
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getEvent
        : ZIO[Any, AwsError, zio.aws.dataexchange.model.Event.ReadOnly] =
      AwsError.unwrapOptionField("event", event)
    def getId: ZIO[Any, AwsError, Id] = AwsError.unwrapOptionField("id", id)
    def getUpdatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dataexchange.model.GetEventActionResponse
  ) extends zio.aws.dataexchange.model.GetEventActionResponse.ReadOnly {
    override val action: Option[zio.aws.dataexchange.model.Action.ReadOnly] =
      scala
        .Option(impl.action())
        .map(value => zio.aws.dataexchange.model.Action.wrap(value))
    override val arn: Option[Arn] = scala
      .Option(impl.arn())
      .map(value => zio.aws.dataexchange.model.primitives.Arn(value))
    override val createdAt: Option[Timestamp] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.dataexchange.model.primitives.Timestamp(value))
    override val event: Option[zio.aws.dataexchange.model.Event.ReadOnly] =
      scala
        .Option(impl.event())
        .map(value => zio.aws.dataexchange.model.Event.wrap(value))
    override val id: Option[Id] = scala
      .Option(impl.id())
      .map(value => zio.aws.dataexchange.model.primitives.Id(value))
    override val updatedAt: Option[Timestamp] = scala
      .Option(impl.updatedAt())
      .map(value => zio.aws.dataexchange.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dataexchange.model.GetEventActionResponse
  ): zio.aws.dataexchange.model.GetEventActionResponse.ReadOnly = new Wrapper(
    impl
  )
}
