package zio.aws.dataexchange.model
import scala.jdk.CollectionConverters._
sealed trait State {
  def unwrap: software.amazon.awssdk.services.dataexchange.model.State
}
object State {
  def wrap(
      value: software.amazon.awssdk.services.dataexchange.model.State
  ): zio.aws.dataexchange.model.State = value match {
    case software.amazon.awssdk.services.dataexchange.model.State.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.dataexchange.model.State.WAITING =>
      val r = WAITING
      r
    case software.amazon.awssdk.services.dataexchange.model.State.IN_PROGRESS =>
      val r = IN_PROGRESS
      r
    case software.amazon.awssdk.services.dataexchange.model.State.ERROR =>
      val r = ERROR
      r
    case software.amazon.awssdk.services.dataexchange.model.State.COMPLETED =>
      val r = COMPLETED
      r
    case software.amazon.awssdk.services.dataexchange.model.State.CANCELLED =>
      val r = CANCELLED
      r
    case software.amazon.awssdk.services.dataexchange.model.State.TIMED_OUT =>
      val r = TIMED_OUT
      r
  }
  case object unknownToSdkVersion extends zio.aws.dataexchange.model.State {
    override def unwrap
        : software.amazon.awssdk.services.dataexchange.model.State =
      software.amazon.awssdk.services.dataexchange.model.State.UNKNOWN_TO_SDK_VERSION
  }
  case object WAITING extends zio.aws.dataexchange.model.State {
    override def unwrap
        : software.amazon.awssdk.services.dataexchange.model.State =
      software.amazon.awssdk.services.dataexchange.model.State.WAITING
  }
  case object IN_PROGRESS extends zio.aws.dataexchange.model.State {
    override def unwrap
        : software.amazon.awssdk.services.dataexchange.model.State =
      software.amazon.awssdk.services.dataexchange.model.State.IN_PROGRESS
  }
  case object ERROR extends zio.aws.dataexchange.model.State {
    override def unwrap
        : software.amazon.awssdk.services.dataexchange.model.State =
      software.amazon.awssdk.services.dataexchange.model.State.ERROR
  }
  case object COMPLETED extends zio.aws.dataexchange.model.State {
    override def unwrap
        : software.amazon.awssdk.services.dataexchange.model.State =
      software.amazon.awssdk.services.dataexchange.model.State.COMPLETED
  }
  case object CANCELLED extends zio.aws.dataexchange.model.State {
    override def unwrap
        : software.amazon.awssdk.services.dataexchange.model.State =
      software.amazon.awssdk.services.dataexchange.model.State.CANCELLED
  }
  case object TIMED_OUT extends zio.aws.dataexchange.model.State {
    override def unwrap
        : software.amazon.awssdk.services.dataexchange.model.State =
      software.amazon.awssdk.services.dataexchange.model.State.TIMED_OUT
  }
}
