package zio.aws.dataexchange.model
import zio.aws.dataexchange.model.primitives.Id
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ExportAssetsToS3ResponseDetails(
    assetDestinations: Iterable[
      zio.aws.dataexchange.model.AssetDestinationEntry
    ],
    dataSetId: Id,
    encryption: Option[zio.aws.dataexchange.model.ExportServerSideEncryption] =
      None,
    revisionId: Id
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dataexchange.model.ExportAssetsToS3ResponseDetails = {
    import ExportAssetsToS3ResponseDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dataexchange.model.ExportAssetsToS3ResponseDetails
      .builder()
      .assetDestinations(assetDestinations.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .dataSetId(Id.unwrap(dataSetId): java.lang.String)
      .optionallyWith(encryption.map(value => value.buildAwsValue()))(
        _.encryption
      )
      .revisionId(Id.unwrap(revisionId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.dataexchange.model.ExportAssetsToS3ResponseDetails.ReadOnly =
    zio.aws.dataexchange.model.ExportAssetsToS3ResponseDetails
      .wrap(buildAwsValue())
}
object ExportAssetsToS3ResponseDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dataexchange.model.ExportAssetsToS3ResponseDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dataexchange.model.ExportAssetsToS3ResponseDetails =
      zio.aws.dataexchange.model.ExportAssetsToS3ResponseDetails(
        assetDestinations.map { item =>
          item.asEditable
        },
        dataSetId,
        encryption.map(value => value.asEditable),
        revisionId
      )
    def assetDestinations
        : List[zio.aws.dataexchange.model.AssetDestinationEntry.ReadOnly]
    def dataSetId: Id
    def encryption
        : Option[zio.aws.dataexchange.model.ExportServerSideEncryption.ReadOnly]
    def revisionId: Id
    def getAssetDestinations: ZIO[Any, Nothing, List[
      zio.aws.dataexchange.model.AssetDestinationEntry.ReadOnly
    ]] = ZIO.succeed(assetDestinations)
    def getDataSetId: ZIO[Any, Nothing, Id] = ZIO.succeed(dataSetId)
    def getEncryption: ZIO[
      Any,
      AwsError,
      zio.aws.dataexchange.model.ExportServerSideEncryption.ReadOnly
    ] = AwsError.unwrapOptionField("encryption", encryption)
    def getRevisionId: ZIO[Any, Nothing, Id] = ZIO.succeed(revisionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dataexchange.model.ExportAssetsToS3ResponseDetails
  ) extends zio.aws.dataexchange.model.ExportAssetsToS3ResponseDetails.ReadOnly {
    override val assetDestinations
        : List[zio.aws.dataexchange.model.AssetDestinationEntry.ReadOnly] = impl
      .assetDestinations()
      .asScala
      .map { item =>
        zio.aws.dataexchange.model.AssetDestinationEntry.wrap(item)
      }
      .toList
    override val dataSetId: Id =
      zio.aws.dataexchange.model.primitives.Id(impl.dataSetId())
    override val encryption: Option[
      zio.aws.dataexchange.model.ExportServerSideEncryption.ReadOnly
    ] = scala
      .Option(impl.encryption())
      .map(value =>
        zio.aws.dataexchange.model.ExportServerSideEncryption.wrap(value)
      )
    override val revisionId: Id =
      zio.aws.dataexchange.model.primitives.Id(impl.revisionId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.dataexchange.model.ExportAssetsToS3ResponseDetails
  ): zio.aws.dataexchange.model.ExportAssetsToS3ResponseDetails.ReadOnly =
    new Wrapper(impl)
}
