package zio.aws.dataexchange.model
import scala.jdk.CollectionConverters._
sealed trait Code {
  def unwrap: software.amazon.awssdk.services.dataexchange.model.Code
}
object Code {
  def wrap(
      value: software.amazon.awssdk.services.dataexchange.model.Code
  ): zio.aws.dataexchange.model.Code = value match {
    case software.amazon.awssdk.services.dataexchange.model.Code.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.dataexchange.model.Code.ACCESS_DENIED_EXCEPTION =>
      val r = ACCESS_DENIED_EXCEPTION
      r
    case software.amazon.awssdk.services.dataexchange.model.Code.INTERNAL_SERVER_EXCEPTION =>
      val r = INTERNAL_SERVER_EXCEPTION
      r
    case software.amazon.awssdk.services.dataexchange.model.Code.MALWARE_DETECTED =>
      val r = MALWARE_DETECTED
      r
    case software.amazon.awssdk.services.dataexchange.model.Code.RESOURCE_NOT_FOUND_EXCEPTION =>
      val r = RESOURCE_NOT_FOUND_EXCEPTION
      r
    case software.amazon.awssdk.services.dataexchange.model.Code.SERVICE_QUOTA_EXCEEDED_EXCEPTION =>
      val r = SERVICE_QUOTA_EXCEEDED_EXCEPTION
      r
    case software.amazon.awssdk.services.dataexchange.model.Code.VALIDATION_EXCEPTION =>
      val r = VALIDATION_EXCEPTION
      r
    case software.amazon.awssdk.services.dataexchange.model.Code.MALWARE_SCAN_ENCRYPTED_FILE =>
      val r = MALWARE_SCAN_ENCRYPTED_FILE
      r
  }
  case object unknownToSdkVersion extends zio.aws.dataexchange.model.Code {
    override def unwrap
        : software.amazon.awssdk.services.dataexchange.model.Code =
      software.amazon.awssdk.services.dataexchange.model.Code.UNKNOWN_TO_SDK_VERSION
  }
  case object ACCESS_DENIED_EXCEPTION extends zio.aws.dataexchange.model.Code {
    override def unwrap
        : software.amazon.awssdk.services.dataexchange.model.Code =
      software.amazon.awssdk.services.dataexchange.model.Code.ACCESS_DENIED_EXCEPTION
  }
  case object INTERNAL_SERVER_EXCEPTION
      extends zio.aws.dataexchange.model.Code {
    override def unwrap
        : software.amazon.awssdk.services.dataexchange.model.Code =
      software.amazon.awssdk.services.dataexchange.model.Code.INTERNAL_SERVER_EXCEPTION
  }
  case object MALWARE_DETECTED extends zio.aws.dataexchange.model.Code {
    override def unwrap
        : software.amazon.awssdk.services.dataexchange.model.Code =
      software.amazon.awssdk.services.dataexchange.model.Code.MALWARE_DETECTED
  }
  case object RESOURCE_NOT_FOUND_EXCEPTION
      extends zio.aws.dataexchange.model.Code {
    override def unwrap
        : software.amazon.awssdk.services.dataexchange.model.Code =
      software.amazon.awssdk.services.dataexchange.model.Code.RESOURCE_NOT_FOUND_EXCEPTION
  }
  case object SERVICE_QUOTA_EXCEEDED_EXCEPTION
      extends zio.aws.dataexchange.model.Code {
    override def unwrap
        : software.amazon.awssdk.services.dataexchange.model.Code =
      software.amazon.awssdk.services.dataexchange.model.Code.SERVICE_QUOTA_EXCEEDED_EXCEPTION
  }
  case object VALIDATION_EXCEPTION extends zio.aws.dataexchange.model.Code {
    override def unwrap
        : software.amazon.awssdk.services.dataexchange.model.Code =
      software.amazon.awssdk.services.dataexchange.model.Code.VALIDATION_EXCEPTION
  }
  case object MALWARE_SCAN_ENCRYPTED_FILE
      extends zio.aws.dataexchange.model.Code {
    override def unwrap
        : software.amazon.awssdk.services.dataexchange.model.Code =
      software.amazon.awssdk.services.dataexchange.model.Code.MALWARE_SCAN_ENCRYPTED_FILE
  }
}
