package zio.aws.dataexchange.model
import zio.aws.dataexchange.model.primitives.{__string, Id}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AssetDestinationEntry(
    assetId: Id,
    bucket: __string,
    key: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dataexchange.model.AssetDestinationEntry = {
    import AssetDestinationEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dataexchange.model.AssetDestinationEntry
      .builder()
      .assetId(Id.unwrap(assetId): java.lang.String)
      .bucket(bucket: java.lang.String)
      .optionallyWith(key.map(value => value: java.lang.String))(_.key)
      .build()
  }
  def asReadOnly: zio.aws.dataexchange.model.AssetDestinationEntry.ReadOnly =
    zio.aws.dataexchange.model.AssetDestinationEntry.wrap(buildAwsValue())
}
object AssetDestinationEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dataexchange.model.AssetDestinationEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dataexchange.model.AssetDestinationEntry =
      zio.aws.dataexchange.model
        .AssetDestinationEntry(assetId, bucket, key.map(value => value))
    def assetId: Id
    def bucket: __string
    def key: Option[__string]
    def getAssetId: ZIO[Any, Nothing, Id] = ZIO.succeed(assetId)
    def getBucket: ZIO[Any, Nothing, __string] = ZIO.succeed(bucket)
    def getKey: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("key", key)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dataexchange.model.AssetDestinationEntry
  ) extends zio.aws.dataexchange.model.AssetDestinationEntry.ReadOnly {
    override val assetId: Id =
      zio.aws.dataexchange.model.primitives.Id(impl.assetId())
    override val bucket: __string = impl.bucket(): __string
    override val key: Option[__string] =
      scala.Option(impl.key()).map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.dataexchange.model.AssetDestinationEntry
  ): zio.aws.dataexchange.model.AssetDestinationEntry.ReadOnly = new Wrapper(
    impl
  )
}
