package zio.aws.dataexchange.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Action(
    exportRevisionToS3: Option[
      zio.aws.dataexchange.model.AutoExportRevisionToS3RequestDetails
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dataexchange.model.Action = {
    import Action.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dataexchange.model.Action
      .builder()
      .optionallyWith(exportRevisionToS3.map(value => value.buildAwsValue()))(
        _.exportRevisionToS3
      )
      .build()
  }
  def asReadOnly: zio.aws.dataexchange.model.Action.ReadOnly =
    zio.aws.dataexchange.model.Action.wrap(buildAwsValue())
}
object Action {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dataexchange.model.Action
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dataexchange.model.Action =
      zio.aws.dataexchange.model
        .Action(exportRevisionToS3.map(value => value.asEditable))
    def exportRevisionToS3: Option[
      zio.aws.dataexchange.model.AutoExportRevisionToS3RequestDetails.ReadOnly
    ]
    def getExportRevisionToS3: ZIO[
      Any,
      AwsError,
      zio.aws.dataexchange.model.AutoExportRevisionToS3RequestDetails.ReadOnly
    ] = AwsError.unwrapOptionField("exportRevisionToS3", exportRevisionToS3)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dataexchange.model.Action
  ) extends zio.aws.dataexchange.model.Action.ReadOnly {
    override val exportRevisionToS3: Option[
      zio.aws.dataexchange.model.AutoExportRevisionToS3RequestDetails.ReadOnly
    ] = scala
      .Option(impl.exportRevisionToS3())
      .map(value =>
        zio.aws.dataexchange.model.AutoExportRevisionToS3RequestDetails
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dataexchange.model.Action
  ): zio.aws.dataexchange.model.Action.ReadOnly = new Wrapper(impl)
}
