package zio.aws.dataexchange.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ResponseDetails(
    exportAssetToSignedUrl: Option[
      zio.aws.dataexchange.model.ExportAssetToSignedUrlResponseDetails
    ] = None,
    exportAssetsToS3: Option[
      zio.aws.dataexchange.model.ExportAssetsToS3ResponseDetails
    ] = None,
    exportRevisionsToS3: Option[
      zio.aws.dataexchange.model.ExportRevisionsToS3ResponseDetails
    ] = None,
    importAssetFromSignedUrl: Option[
      zio.aws.dataexchange.model.ImportAssetFromSignedUrlResponseDetails
    ] = None,
    importAssetsFromS3: Option[
      zio.aws.dataexchange.model.ImportAssetsFromS3ResponseDetails
    ] = None,
    importAssetsFromRedshiftDataShares: Option[
      zio.aws.dataexchange.model.ImportAssetsFromRedshiftDataSharesResponseDetails
    ] = None,
    importAssetFromApiGatewayApi: Option[
      zio.aws.dataexchange.model.ImportAssetFromApiGatewayApiResponseDetails
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dataexchange.model.ResponseDetails = {
    import ResponseDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dataexchange.model.ResponseDetails
      .builder()
      .optionallyWith(
        exportAssetToSignedUrl.map(value => value.buildAwsValue())
      )(_.exportAssetToSignedUrl)
      .optionallyWith(exportAssetsToS3.map(value => value.buildAwsValue()))(
        _.exportAssetsToS3
      )
      .optionallyWith(exportRevisionsToS3.map(value => value.buildAwsValue()))(
        _.exportRevisionsToS3
      )
      .optionallyWith(
        importAssetFromSignedUrl.map(value => value.buildAwsValue())
      )(_.importAssetFromSignedUrl)
      .optionallyWith(importAssetsFromS3.map(value => value.buildAwsValue()))(
        _.importAssetsFromS3
      )
      .optionallyWith(
        importAssetsFromRedshiftDataShares.map(value => value.buildAwsValue())
      )(_.importAssetsFromRedshiftDataShares)
      .optionallyWith(
        importAssetFromApiGatewayApi.map(value => value.buildAwsValue())
      )(_.importAssetFromApiGatewayApi)
      .build()
  }
  def asReadOnly: zio.aws.dataexchange.model.ResponseDetails.ReadOnly =
    zio.aws.dataexchange.model.ResponseDetails.wrap(buildAwsValue())
}
object ResponseDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dataexchange.model.ResponseDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dataexchange.model.ResponseDetails =
      zio.aws.dataexchange.model.ResponseDetails(
        exportAssetToSignedUrl.map(value => value.asEditable),
        exportAssetsToS3.map(value => value.asEditable),
        exportRevisionsToS3.map(value => value.asEditable),
        importAssetFromSignedUrl.map(value => value.asEditable),
        importAssetsFromS3.map(value => value.asEditable),
        importAssetsFromRedshiftDataShares.map(value => value.asEditable),
        importAssetFromApiGatewayApi.map(value => value.asEditable)
      )
    def exportAssetToSignedUrl: Option[
      zio.aws.dataexchange.model.ExportAssetToSignedUrlResponseDetails.ReadOnly
    ]
    def exportAssetsToS3: Option[
      zio.aws.dataexchange.model.ExportAssetsToS3ResponseDetails.ReadOnly
    ]
    def exportRevisionsToS3: Option[
      zio.aws.dataexchange.model.ExportRevisionsToS3ResponseDetails.ReadOnly
    ]
    def importAssetFromSignedUrl: Option[
      zio.aws.dataexchange.model.ImportAssetFromSignedUrlResponseDetails.ReadOnly
    ]
    def importAssetsFromS3: Option[
      zio.aws.dataexchange.model.ImportAssetsFromS3ResponseDetails.ReadOnly
    ]
    def importAssetsFromRedshiftDataShares: Option[
      zio.aws.dataexchange.model.ImportAssetsFromRedshiftDataSharesResponseDetails.ReadOnly
    ]
    def importAssetFromApiGatewayApi: Option[
      zio.aws.dataexchange.model.ImportAssetFromApiGatewayApiResponseDetails.ReadOnly
    ]
    def getExportAssetToSignedUrl: ZIO[
      Any,
      AwsError,
      zio.aws.dataexchange.model.ExportAssetToSignedUrlResponseDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "exportAssetToSignedUrl",
      exportAssetToSignedUrl
    )
    def getExportAssetsToS3: ZIO[
      Any,
      AwsError,
      zio.aws.dataexchange.model.ExportAssetsToS3ResponseDetails.ReadOnly
    ] = AwsError.unwrapOptionField("exportAssetsToS3", exportAssetsToS3)
    def getExportRevisionsToS3: ZIO[
      Any,
      AwsError,
      zio.aws.dataexchange.model.ExportRevisionsToS3ResponseDetails.ReadOnly
    ] = AwsError.unwrapOptionField("exportRevisionsToS3", exportRevisionsToS3)
    def getImportAssetFromSignedUrl: ZIO[
      Any,
      AwsError,
      zio.aws.dataexchange.model.ImportAssetFromSignedUrlResponseDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "importAssetFromSignedUrl",
      importAssetFromSignedUrl
    )
    def getImportAssetsFromS3: ZIO[
      Any,
      AwsError,
      zio.aws.dataexchange.model.ImportAssetsFromS3ResponseDetails.ReadOnly
    ] = AwsError.unwrapOptionField("importAssetsFromS3", importAssetsFromS3)
    def getImportAssetsFromRedshiftDataShares: ZIO[
      Any,
      AwsError,
      zio.aws.dataexchange.model.ImportAssetsFromRedshiftDataSharesResponseDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "importAssetsFromRedshiftDataShares",
      importAssetsFromRedshiftDataShares
    )
    def getImportAssetFromApiGatewayApi: ZIO[
      Any,
      AwsError,
      zio.aws.dataexchange.model.ImportAssetFromApiGatewayApiResponseDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "importAssetFromApiGatewayApi",
      importAssetFromApiGatewayApi
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dataexchange.model.ResponseDetails
  ) extends zio.aws.dataexchange.model.ResponseDetails.ReadOnly {
    override val exportAssetToSignedUrl: Option[
      zio.aws.dataexchange.model.ExportAssetToSignedUrlResponseDetails.ReadOnly
    ] = scala
      .Option(impl.exportAssetToSignedUrl())
      .map(value =>
        zio.aws.dataexchange.model.ExportAssetToSignedUrlResponseDetails
          .wrap(value)
      )
    override val exportAssetsToS3: Option[
      zio.aws.dataexchange.model.ExportAssetsToS3ResponseDetails.ReadOnly
    ] = scala
      .Option(impl.exportAssetsToS3())
      .map(value =>
        zio.aws.dataexchange.model.ExportAssetsToS3ResponseDetails.wrap(value)
      )
    override val exportRevisionsToS3: Option[
      zio.aws.dataexchange.model.ExportRevisionsToS3ResponseDetails.ReadOnly
    ] = scala
      .Option(impl.exportRevisionsToS3())
      .map(value =>
        zio.aws.dataexchange.model.ExportRevisionsToS3ResponseDetails
          .wrap(value)
      )
    override val importAssetFromSignedUrl: Option[
      zio.aws.dataexchange.model.ImportAssetFromSignedUrlResponseDetails.ReadOnly
    ] = scala
      .Option(impl.importAssetFromSignedUrl())
      .map(value =>
        zio.aws.dataexchange.model.ImportAssetFromSignedUrlResponseDetails
          .wrap(value)
      )
    override val importAssetsFromS3: Option[
      zio.aws.dataexchange.model.ImportAssetsFromS3ResponseDetails.ReadOnly
    ] = scala
      .Option(impl.importAssetsFromS3())
      .map(value =>
        zio.aws.dataexchange.model.ImportAssetsFromS3ResponseDetails.wrap(value)
      )
    override val importAssetsFromRedshiftDataShares: Option[
      zio.aws.dataexchange.model.ImportAssetsFromRedshiftDataSharesResponseDetails.ReadOnly
    ] = scala
      .Option(impl.importAssetsFromRedshiftDataShares())
      .map(value =>
        zio.aws.dataexchange.model.ImportAssetsFromRedshiftDataSharesResponseDetails
          .wrap(value)
      )
    override val importAssetFromApiGatewayApi: Option[
      zio.aws.dataexchange.model.ImportAssetFromApiGatewayApiResponseDetails.ReadOnly
    ] = scala
      .Option(impl.importAssetFromApiGatewayApi())
      .map(value =>
        zio.aws.dataexchange.model.ImportAssetFromApiGatewayApiResponseDetails
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dataexchange.model.ResponseDetails
  ): zio.aws.dataexchange.model.ResponseDetails.ReadOnly = new Wrapper(impl)
}
