package zio.aws.dataexchange.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class RequestDetails(
    exportAssetToSignedUrl: Option[
      zio.aws.dataexchange.model.ExportAssetToSignedUrlRequestDetails
    ] = None,
    exportAssetsToS3: Option[
      zio.aws.dataexchange.model.ExportAssetsToS3RequestDetails
    ] = None,
    exportRevisionsToS3: Option[
      zio.aws.dataexchange.model.ExportRevisionsToS3RequestDetails
    ] = None,
    importAssetFromSignedUrl: Option[
      zio.aws.dataexchange.model.ImportAssetFromSignedUrlRequestDetails
    ] = None,
    importAssetsFromS3: Option[
      zio.aws.dataexchange.model.ImportAssetsFromS3RequestDetails
    ] = None,
    importAssetsFromRedshiftDataShares: Option[
      zio.aws.dataexchange.model.ImportAssetsFromRedshiftDataSharesRequestDetails
    ] = None,
    importAssetFromApiGatewayApi: Option[
      zio.aws.dataexchange.model.ImportAssetFromApiGatewayApiRequestDetails
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dataexchange.model.RequestDetails = {
    import RequestDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dataexchange.model.RequestDetails
      .builder()
      .optionallyWith(
        exportAssetToSignedUrl.map(value => value.buildAwsValue())
      )(_.exportAssetToSignedUrl)
      .optionallyWith(exportAssetsToS3.map(value => value.buildAwsValue()))(
        _.exportAssetsToS3
      )
      .optionallyWith(exportRevisionsToS3.map(value => value.buildAwsValue()))(
        _.exportRevisionsToS3
      )
      .optionallyWith(
        importAssetFromSignedUrl.map(value => value.buildAwsValue())
      )(_.importAssetFromSignedUrl)
      .optionallyWith(importAssetsFromS3.map(value => value.buildAwsValue()))(
        _.importAssetsFromS3
      )
      .optionallyWith(
        importAssetsFromRedshiftDataShares.map(value => value.buildAwsValue())
      )(_.importAssetsFromRedshiftDataShares)
      .optionallyWith(
        importAssetFromApiGatewayApi.map(value => value.buildAwsValue())
      )(_.importAssetFromApiGatewayApi)
      .build()
  }
  def asReadOnly: zio.aws.dataexchange.model.RequestDetails.ReadOnly =
    zio.aws.dataexchange.model.RequestDetails.wrap(buildAwsValue())
}
object RequestDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dataexchange.model.RequestDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dataexchange.model.RequestDetails =
      zio.aws.dataexchange.model.RequestDetails(
        exportAssetToSignedUrl.map(value => value.asEditable),
        exportAssetsToS3.map(value => value.asEditable),
        exportRevisionsToS3.map(value => value.asEditable),
        importAssetFromSignedUrl.map(value => value.asEditable),
        importAssetsFromS3.map(value => value.asEditable),
        importAssetsFromRedshiftDataShares.map(value => value.asEditable),
        importAssetFromApiGatewayApi.map(value => value.asEditable)
      )
    def exportAssetToSignedUrl: Option[
      zio.aws.dataexchange.model.ExportAssetToSignedUrlRequestDetails.ReadOnly
    ]
    def exportAssetsToS3: Option[
      zio.aws.dataexchange.model.ExportAssetsToS3RequestDetails.ReadOnly
    ]
    def exportRevisionsToS3: Option[
      zio.aws.dataexchange.model.ExportRevisionsToS3RequestDetails.ReadOnly
    ]
    def importAssetFromSignedUrl: Option[
      zio.aws.dataexchange.model.ImportAssetFromSignedUrlRequestDetails.ReadOnly
    ]
    def importAssetsFromS3: Option[
      zio.aws.dataexchange.model.ImportAssetsFromS3RequestDetails.ReadOnly
    ]
    def importAssetsFromRedshiftDataShares: Option[
      zio.aws.dataexchange.model.ImportAssetsFromRedshiftDataSharesRequestDetails.ReadOnly
    ]
    def importAssetFromApiGatewayApi: Option[
      zio.aws.dataexchange.model.ImportAssetFromApiGatewayApiRequestDetails.ReadOnly
    ]
    def getExportAssetToSignedUrl: ZIO[
      Any,
      AwsError,
      zio.aws.dataexchange.model.ExportAssetToSignedUrlRequestDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "exportAssetToSignedUrl",
      exportAssetToSignedUrl
    )
    def getExportAssetsToS3: ZIO[
      Any,
      AwsError,
      zio.aws.dataexchange.model.ExportAssetsToS3RequestDetails.ReadOnly
    ] = AwsError.unwrapOptionField("exportAssetsToS3", exportAssetsToS3)
    def getExportRevisionsToS3: ZIO[
      Any,
      AwsError,
      zio.aws.dataexchange.model.ExportRevisionsToS3RequestDetails.ReadOnly
    ] = AwsError.unwrapOptionField("exportRevisionsToS3", exportRevisionsToS3)
    def getImportAssetFromSignedUrl: ZIO[
      Any,
      AwsError,
      zio.aws.dataexchange.model.ImportAssetFromSignedUrlRequestDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "importAssetFromSignedUrl",
      importAssetFromSignedUrl
    )
    def getImportAssetsFromS3: ZIO[
      Any,
      AwsError,
      zio.aws.dataexchange.model.ImportAssetsFromS3RequestDetails.ReadOnly
    ] = AwsError.unwrapOptionField("importAssetsFromS3", importAssetsFromS3)
    def getImportAssetsFromRedshiftDataShares: ZIO[
      Any,
      AwsError,
      zio.aws.dataexchange.model.ImportAssetsFromRedshiftDataSharesRequestDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "importAssetsFromRedshiftDataShares",
      importAssetsFromRedshiftDataShares
    )
    def getImportAssetFromApiGatewayApi: ZIO[
      Any,
      AwsError,
      zio.aws.dataexchange.model.ImportAssetFromApiGatewayApiRequestDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "importAssetFromApiGatewayApi",
      importAssetFromApiGatewayApi
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dataexchange.model.RequestDetails
  ) extends zio.aws.dataexchange.model.RequestDetails.ReadOnly {
    override val exportAssetToSignedUrl: Option[
      zio.aws.dataexchange.model.ExportAssetToSignedUrlRequestDetails.ReadOnly
    ] = scala
      .Option(impl.exportAssetToSignedUrl())
      .map(value =>
        zio.aws.dataexchange.model.ExportAssetToSignedUrlRequestDetails
          .wrap(value)
      )
    override val exportAssetsToS3: Option[
      zio.aws.dataexchange.model.ExportAssetsToS3RequestDetails.ReadOnly
    ] = scala
      .Option(impl.exportAssetsToS3())
      .map(value =>
        zio.aws.dataexchange.model.ExportAssetsToS3RequestDetails.wrap(value)
      )
    override val exportRevisionsToS3: Option[
      zio.aws.dataexchange.model.ExportRevisionsToS3RequestDetails.ReadOnly
    ] = scala
      .Option(impl.exportRevisionsToS3())
      .map(value =>
        zio.aws.dataexchange.model.ExportRevisionsToS3RequestDetails.wrap(value)
      )
    override val importAssetFromSignedUrl: Option[
      zio.aws.dataexchange.model.ImportAssetFromSignedUrlRequestDetails.ReadOnly
    ] = scala
      .Option(impl.importAssetFromSignedUrl())
      .map(value =>
        zio.aws.dataexchange.model.ImportAssetFromSignedUrlRequestDetails
          .wrap(value)
      )
    override val importAssetsFromS3: Option[
      zio.aws.dataexchange.model.ImportAssetsFromS3RequestDetails.ReadOnly
    ] = scala
      .Option(impl.importAssetsFromS3())
      .map(value =>
        zio.aws.dataexchange.model.ImportAssetsFromS3RequestDetails.wrap(value)
      )
    override val importAssetsFromRedshiftDataShares: Option[
      zio.aws.dataexchange.model.ImportAssetsFromRedshiftDataSharesRequestDetails.ReadOnly
    ] = scala
      .Option(impl.importAssetsFromRedshiftDataShares())
      .map(value =>
        zio.aws.dataexchange.model.ImportAssetsFromRedshiftDataSharesRequestDetails
          .wrap(value)
      )
    override val importAssetFromApiGatewayApi: Option[
      zio.aws.dataexchange.model.ImportAssetFromApiGatewayApiRequestDetails.ReadOnly
    ] = scala
      .Option(impl.importAssetFromApiGatewayApi())
      .map(value =>
        zio.aws.dataexchange.model.ImportAssetFromApiGatewayApiRequestDetails
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dataexchange.model.RequestDetails
  ): zio.aws.dataexchange.model.RequestDetails.ReadOnly = new Wrapper(impl)
}
