package zio.aws.dataexchange.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AssetDetails(
    s3SnapshotAsset: Option[zio.aws.dataexchange.model.S3SnapshotAsset] = None,
    redshiftDataShareAsset: Option[
      zio.aws.dataexchange.model.RedshiftDataShareAsset
    ] = None,
    apiGatewayApiAsset: Option[zio.aws.dataexchange.model.ApiGatewayApiAsset] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dataexchange.model.AssetDetails = {
    import AssetDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dataexchange.model.AssetDetails
      .builder()
      .optionallyWith(s3SnapshotAsset.map(value => value.buildAwsValue()))(
        _.s3SnapshotAsset
      )
      .optionallyWith(
        redshiftDataShareAsset.map(value => value.buildAwsValue())
      )(_.redshiftDataShareAsset)
      .optionallyWith(apiGatewayApiAsset.map(value => value.buildAwsValue()))(
        _.apiGatewayApiAsset
      )
      .build()
  }
  def asReadOnly: zio.aws.dataexchange.model.AssetDetails.ReadOnly =
    zio.aws.dataexchange.model.AssetDetails.wrap(buildAwsValue())
}
object AssetDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dataexchange.model.AssetDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dataexchange.model.AssetDetails =
      zio.aws.dataexchange.model.AssetDetails(
        s3SnapshotAsset.map(value => value.asEditable),
        redshiftDataShareAsset.map(value => value.asEditable),
        apiGatewayApiAsset.map(value => value.asEditable)
      )
    def s3SnapshotAsset
        : Option[zio.aws.dataexchange.model.S3SnapshotAsset.ReadOnly]
    def redshiftDataShareAsset
        : Option[zio.aws.dataexchange.model.RedshiftDataShareAsset.ReadOnly]
    def apiGatewayApiAsset
        : Option[zio.aws.dataexchange.model.ApiGatewayApiAsset.ReadOnly]
    def getS3SnapshotAsset: ZIO[
      Any,
      AwsError,
      zio.aws.dataexchange.model.S3SnapshotAsset.ReadOnly
    ] = AwsError.unwrapOptionField("s3SnapshotAsset", s3SnapshotAsset)
    def getRedshiftDataShareAsset: ZIO[
      Any,
      AwsError,
      zio.aws.dataexchange.model.RedshiftDataShareAsset.ReadOnly
    ] = AwsError.unwrapOptionField(
      "redshiftDataShareAsset",
      redshiftDataShareAsset
    )
    def getApiGatewayApiAsset: ZIO[
      Any,
      AwsError,
      zio.aws.dataexchange.model.ApiGatewayApiAsset.ReadOnly
    ] = AwsError.unwrapOptionField("apiGatewayApiAsset", apiGatewayApiAsset)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dataexchange.model.AssetDetails
  ) extends zio.aws.dataexchange.model.AssetDetails.ReadOnly {
    override val s3SnapshotAsset
        : Option[zio.aws.dataexchange.model.S3SnapshotAsset.ReadOnly] = scala
      .Option(impl.s3SnapshotAsset())
      .map(value => zio.aws.dataexchange.model.S3SnapshotAsset.wrap(value))
    override val redshiftDataShareAsset
        : Option[zio.aws.dataexchange.model.RedshiftDataShareAsset.ReadOnly] =
      scala
        .Option(impl.redshiftDataShareAsset())
        .map(value =>
          zio.aws.dataexchange.model.RedshiftDataShareAsset.wrap(value)
        )
    override val apiGatewayApiAsset
        : Option[zio.aws.dataexchange.model.ApiGatewayApiAsset.ReadOnly] = scala
      .Option(impl.apiGatewayApiAsset())
      .map(value => zio.aws.dataexchange.model.ApiGatewayApiAsset.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dataexchange.model.AssetDetails
  ): zio.aws.dataexchange.model.AssetDetails.ReadOnly = new Wrapper(impl)
}
