package zio.aws.dataexchange.model
import zio.aws.dataexchange.model.primitives.{
  Id,
  __stringMin24Max24PatternAZaZ094AZaZ092AZaZ093,
  __string,
  ApiDescription
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ImportAssetFromApiGatewayApiRequestDetails(
    apiDescription: Option[ApiDescription] = None,
    apiId: __string,
    apiKey: Option[__string] = None,
    apiName: __string,
    apiSpecificationMd5Hash: __stringMin24Max24PatternAZaZ094AZaZ092AZaZ093,
    dataSetId: Id,
    protocolType: zio.aws.dataexchange.model.ProtocolType,
    revisionId: Id,
    stage: __string
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dataexchange.model.ImportAssetFromApiGatewayApiRequestDetails = {
    import ImportAssetFromApiGatewayApiRequestDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dataexchange.model.ImportAssetFromApiGatewayApiRequestDetails
      .builder()
      .optionallyWith(
        apiDescription.map(value =>
          ApiDescription.unwrap(value): java.lang.String
        )
      )(_.apiDescription)
      .apiId(apiId: java.lang.String)
      .optionallyWith(apiKey.map(value => value: java.lang.String))(_.apiKey)
      .apiName(apiName: java.lang.String)
      .apiSpecificationMd5Hash(apiSpecificationMd5Hash: java.lang.String)
      .dataSetId(Id.unwrap(dataSetId): java.lang.String)
      .protocolType(protocolType.unwrap)
      .revisionId(Id.unwrap(revisionId): java.lang.String)
      .stage(stage: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.dataexchange.model.ImportAssetFromApiGatewayApiRequestDetails.ReadOnly =
    zio.aws.dataexchange.model.ImportAssetFromApiGatewayApiRequestDetails
      .wrap(buildAwsValue())
}
object ImportAssetFromApiGatewayApiRequestDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dataexchange.model.ImportAssetFromApiGatewayApiRequestDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.dataexchange.model.ImportAssetFromApiGatewayApiRequestDetails =
      zio.aws.dataexchange.model.ImportAssetFromApiGatewayApiRequestDetails(
        apiDescription.map(value => value),
        apiId,
        apiKey.map(value => value),
        apiName,
        apiSpecificationMd5Hash,
        dataSetId,
        protocolType,
        revisionId,
        stage
      )
    def apiDescription: Option[ApiDescription]
    def apiId: __string
    def apiKey: Option[__string]
    def apiName: __string
    def apiSpecificationMd5Hash: __stringMin24Max24PatternAZaZ094AZaZ092AZaZ093
    def dataSetId: Id
    def protocolType: zio.aws.dataexchange.model.ProtocolType
    def revisionId: Id
    def stage: __string
    def getApiDescription: ZIO[Any, AwsError, ApiDescription] =
      AwsError.unwrapOptionField("apiDescription", apiDescription)
    def getApiId: ZIO[Any, Nothing, __string] = ZIO.succeed(apiId)
    def getApiKey: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("apiKey", apiKey)
    def getApiName: ZIO[Any, Nothing, __string] = ZIO.succeed(apiName)
    def getApiSpecificationMd5Hash
        : ZIO[Any, Nothing, __stringMin24Max24PatternAZaZ094AZaZ092AZaZ093] =
      ZIO.succeed(apiSpecificationMd5Hash)
    def getDataSetId: ZIO[Any, Nothing, Id] = ZIO.succeed(dataSetId)
    def getProtocolType
        : ZIO[Any, Nothing, zio.aws.dataexchange.model.ProtocolType] =
      ZIO.succeed(protocolType)
    def getRevisionId: ZIO[Any, Nothing, Id] = ZIO.succeed(revisionId)
    def getStage: ZIO[Any, Nothing, __string] = ZIO.succeed(stage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dataexchange.model.ImportAssetFromApiGatewayApiRequestDetails
  ) extends zio.aws.dataexchange.model.ImportAssetFromApiGatewayApiRequestDetails.ReadOnly {
    override val apiDescription: Option[ApiDescription] = scala
      .Option(impl.apiDescription())
      .map(value => zio.aws.dataexchange.model.primitives.ApiDescription(value))
    override val apiId: __string = impl.apiId(): __string
    override val apiKey: Option[__string] =
      scala.Option(impl.apiKey()).map(value => value: __string)
    override val apiName: __string = impl.apiName(): __string
    override val apiSpecificationMd5Hash
        : __stringMin24Max24PatternAZaZ094AZaZ092AZaZ093 = impl
      .apiSpecificationMd5Hash(): __stringMin24Max24PatternAZaZ094AZaZ092AZaZ093
    override val dataSetId: Id =
      zio.aws.dataexchange.model.primitives.Id(impl.dataSetId())
    override val protocolType: zio.aws.dataexchange.model.ProtocolType =
      zio.aws.dataexchange.model.ProtocolType.wrap(impl.protocolType())
    override val revisionId: Id =
      zio.aws.dataexchange.model.primitives.Id(impl.revisionId())
    override val stage: __string = impl.stage(): __string
  }
  def wrap(
      impl: software.amazon.awssdk.services.dataexchange.model.ImportAssetFromApiGatewayApiRequestDetails
  ): zio.aws.dataexchange.model.ImportAssetFromApiGatewayApiRequestDetails.ReadOnly =
    new Wrapper(impl)
}
