package zio.aws.dataexchange.model
import zio.aws.dataexchange.model.primitives.{Id, Timestamp, Arn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class GetJobResponse(
    arn: Option[Arn] = None,
    createdAt: Option[Timestamp] = None,
    details: Option[zio.aws.dataexchange.model.ResponseDetails] = None,
    errors: Option[Iterable[zio.aws.dataexchange.model.JobError]] = None,
    id: Option[Id] = None,
    state: Option[zio.aws.dataexchange.model.State] = None,
    `type`: Option[zio.aws.dataexchange.model.Type] = None,
    updatedAt: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dataexchange.model.GetJobResponse = {
    import GetJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dataexchange.model.GetJobResponse
      .builder()
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(details.map(value => value.buildAwsValue()))(_.details)
      .optionallyWith(
        errors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.errors)
      .optionallyWith(id.map(value => Id.unwrap(value): java.lang.String))(_.id)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(updatedAt.map(value => Timestamp.unwrap(value): Instant))(
        _.updatedAt
      )
      .build()
  }
  def asReadOnly: zio.aws.dataexchange.model.GetJobResponse.ReadOnly =
    zio.aws.dataexchange.model.GetJobResponse.wrap(buildAwsValue())
}
object GetJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dataexchange.model.GetJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dataexchange.model.GetJobResponse =
      zio.aws.dataexchange.model.GetJobResponse(
        arn.map(value => value),
        createdAt.map(value => value),
        details.map(value => value.asEditable),
        errors.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        id.map(value => value),
        state.map(value => value),
        `type`.map(value => value),
        updatedAt.map(value => value)
      )
    def arn: Option[Arn]
    def createdAt: Option[Timestamp]
    def details: Option[zio.aws.dataexchange.model.ResponseDetails.ReadOnly]
    def errors: Option[List[zio.aws.dataexchange.model.JobError.ReadOnly]]
    def id: Option[Id]
    def state: Option[zio.aws.dataexchange.model.State]
    def `type`: Option[zio.aws.dataexchange.model.Type]
    def updatedAt: Option[Timestamp]
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getDetails: ZIO[
      Any,
      AwsError,
      zio.aws.dataexchange.model.ResponseDetails.ReadOnly
    ] = AwsError.unwrapOptionField("details", details)
    def getErrors: ZIO[Any, AwsError, List[
      zio.aws.dataexchange.model.JobError.ReadOnly
    ]] = AwsError.unwrapOptionField("errors", errors)
    def getId: ZIO[Any, AwsError, Id] = AwsError.unwrapOptionField("id", id)
    def getState: ZIO[Any, AwsError, zio.aws.dataexchange.model.State] =
      AwsError.unwrapOptionField("state", state)
    def getType: ZIO[Any, AwsError, zio.aws.dataexchange.model.Type] =
      AwsError.unwrapOptionField("type", `type`)
    def getUpdatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dataexchange.model.GetJobResponse
  ) extends zio.aws.dataexchange.model.GetJobResponse.ReadOnly {
    override val arn: Option[Arn] = scala
      .Option(impl.arn())
      .map(value => zio.aws.dataexchange.model.primitives.Arn(value))
    override val createdAt: Option[Timestamp] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.dataexchange.model.primitives.Timestamp(value))
    override val details
        : Option[zio.aws.dataexchange.model.ResponseDetails.ReadOnly] = scala
      .Option(impl.details())
      .map(value => zio.aws.dataexchange.model.ResponseDetails.wrap(value))
    override val errors
        : Option[List[zio.aws.dataexchange.model.JobError.ReadOnly]] = scala
      .Option(impl.errors())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.dataexchange.model.JobError.wrap(item)
        }.toList
      )
    override val id: Option[Id] = scala
      .Option(impl.id())
      .map(value => zio.aws.dataexchange.model.primitives.Id(value))
    override val state: Option[zio.aws.dataexchange.model.State] = scala
      .Option(impl.state())
      .map(value => zio.aws.dataexchange.model.State.wrap(value))
    override val `type`: Option[zio.aws.dataexchange.model.Type] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.dataexchange.model.Type.wrap(value))
    override val updatedAt: Option[Timestamp] = scala
      .Option(impl.updatedAt())
      .map(value => zio.aws.dataexchange.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dataexchange.model.GetJobResponse
  ): zio.aws.dataexchange.model.GetJobResponse.ReadOnly = new Wrapper(impl)
}
