package zio.aws.dataexchange
import zio.aws.dataexchange.model.AssetEntry.ReadOnly
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.dataexchange.{
  DataExchangeAsyncClientBuilder,
  DataExchangeAsyncClient
}
import software.amazon.awssdk.services.dataexchange.model.{
  DeleteAssetRequest,
  UpdateAssetResponse,
  DeleteDataSetRequest,
  GetEventActionRequest,
  ListDataSetsRequest,
  UpdateRevisionResponse,
  DeleteEventActionResponse,
  AssetEntry,
  UpdateDataSetResponse,
  CancelJobRequest,
  CreateDataSetRequest,
  CancelJobResponse,
  ListJobsRequest,
  GetDataSetRequest,
  UpdateEventActionResponse,
  StartJobResponse,
  GetJobRequest,
  DeleteDataSetResponse,
  ListEventActionsResponse,
  ListTagsForResourceRequest,
  GetRevisionRequest,
  CreateEventActionRequest,
  GetJobResponse,
  GetAssetResponse,
  DataSetEntry,
  ListTagsForResourceResponse,
  UntagResourceResponse,
  CreateRevisionRequest,
  UpdateDataSetRequest,
  DeleteAssetResponse,
  DeleteEventActionRequest,
  EventActionEntry,
  CreateEventActionResponse,
  UpdateAssetRequest,
  ListDataSetRevisionsResponse,
  DeleteRevisionResponse,
  GetRevisionResponse,
  GetEventActionResponse,
  UntagResourceRequest,
  CreateJobRequest,
  GetAssetRequest,
  ListDataSetRevisionsRequest,
  DeleteRevisionRequest,
  RevisionEntry,
  CreateDataSetResponse,
  UpdateRevisionRequest,
  ListJobsResponse,
  StartJobRequest,
  GetDataSetResponse,
  UpdateEventActionRequest,
  TagResourceResponse,
  CreateRevisionResponse,
  JobEntry,
  ListEventActionsRequest,
  TagResourceRequest,
  ListDataSetsResponse,
  ListRevisionAssetsResponse,
  CreateJobResponse,
  ListRevisionAssetsRequest
}
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, ZManaged, IO, ZIO, ZLayer}
import zio.stream.ZStream
import scala.jdk.CollectionConverters._
trait DataExchange extends AspectSupport[DataExchange] {
  val api: DataExchangeAsyncClient
  def startJob(
      request: zio.aws.dataexchange.model.StartJobRequest
  ): IO[AwsError, zio.aws.dataexchange.model.StartJobResponse.ReadOnly]
  def listDataSetRevisions(
      request: zio.aws.dataexchange.model.ListDataSetRevisionsRequest
  ): ZStream[Any, AwsError, zio.aws.dataexchange.model.RevisionEntry.ReadOnly]
  def listDataSetRevisionsPaginated(
      request: zio.aws.dataexchange.model.ListDataSetRevisionsRequest
  ): IO[
    AwsError,
    zio.aws.dataexchange.model.ListDataSetRevisionsResponse.ReadOnly
  ]
  def deleteDataSet(
      request: zio.aws.dataexchange.model.DeleteDataSetRequest
  ): IO[AwsError, Unit]
  def createJob(
      request: zio.aws.dataexchange.model.CreateJobRequest
  ): IO[AwsError, zio.aws.dataexchange.model.CreateJobResponse.ReadOnly]
  def cancelJob(
      request: zio.aws.dataexchange.model.CancelJobRequest
  ): IO[AwsError, Unit]
  def listDataSets(
      request: zio.aws.dataexchange.model.ListDataSetsRequest
  ): ZStream[Any, AwsError, zio.aws.dataexchange.model.DataSetEntry.ReadOnly]
  def listDataSetsPaginated(
      request: zio.aws.dataexchange.model.ListDataSetsRequest
  ): IO[AwsError, zio.aws.dataexchange.model.ListDataSetsResponse.ReadOnly]
  def createEventAction(
      request: zio.aws.dataexchange.model.CreateEventActionRequest
  ): IO[AwsError, zio.aws.dataexchange.model.CreateEventActionResponse.ReadOnly]
  def updateEventAction(
      request: zio.aws.dataexchange.model.UpdateEventActionRequest
  ): IO[AwsError, zio.aws.dataexchange.model.UpdateEventActionResponse.ReadOnly]
  def listEventActions(
      request: zio.aws.dataexchange.model.ListEventActionsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.dataexchange.model.EventActionEntry.ReadOnly
  ]
  def listEventActionsPaginated(
      request: zio.aws.dataexchange.model.ListEventActionsRequest
  ): IO[AwsError, zio.aws.dataexchange.model.ListEventActionsResponse.ReadOnly]
  def deleteEventAction(
      request: zio.aws.dataexchange.model.DeleteEventActionRequest
  ): IO[AwsError, Unit]
  def getEventAction(
      request: zio.aws.dataexchange.model.GetEventActionRequest
  ): IO[AwsError, zio.aws.dataexchange.model.GetEventActionResponse.ReadOnly]
  def updateRevision(
      request: zio.aws.dataexchange.model.UpdateRevisionRequest
  ): IO[AwsError, zio.aws.dataexchange.model.UpdateRevisionResponse.ReadOnly]
  def createDataSet(
      request: zio.aws.dataexchange.model.CreateDataSetRequest
  ): IO[AwsError, zio.aws.dataexchange.model.CreateDataSetResponse.ReadOnly]
  def untagResource(
      request: zio.aws.dataexchange.model.UntagResourceRequest
  ): IO[AwsError, Unit]
  def deleteRevision(
      request: zio.aws.dataexchange.model.DeleteRevisionRequest
  ): IO[AwsError, Unit]
  def getJob(
      request: zio.aws.dataexchange.model.GetJobRequest
  ): IO[AwsError, zio.aws.dataexchange.model.GetJobResponse.ReadOnly]
  def getAsset(
      request: zio.aws.dataexchange.model.GetAssetRequest
  ): IO[AwsError, zio.aws.dataexchange.model.GetAssetResponse.ReadOnly]
  def getRevision(
      request: zio.aws.dataexchange.model.GetRevisionRequest
  ): IO[AwsError, zio.aws.dataexchange.model.GetRevisionResponse.ReadOnly]
  def deleteAsset(
      request: zio.aws.dataexchange.model.DeleteAssetRequest
  ): IO[AwsError, Unit]
  def updateDataSet(
      request: zio.aws.dataexchange.model.UpdateDataSetRequest
  ): IO[AwsError, zio.aws.dataexchange.model.UpdateDataSetResponse.ReadOnly]
  def listTagsForResource(
      request: zio.aws.dataexchange.model.ListTagsForResourceRequest
  ): IO[
    AwsError,
    zio.aws.dataexchange.model.ListTagsForResourceResponse.ReadOnly
  ]
  def listJobs(
      request: zio.aws.dataexchange.model.ListJobsRequest
  ): ZStream[Any, AwsError, zio.aws.dataexchange.model.JobEntry.ReadOnly]
  def listJobsPaginated(
      request: zio.aws.dataexchange.model.ListJobsRequest
  ): IO[AwsError, zio.aws.dataexchange.model.ListJobsResponse.ReadOnly]
  def tagResource(
      request: zio.aws.dataexchange.model.TagResourceRequest
  ): IO[AwsError, Unit]
  def listRevisionAssets(
      request: zio.aws.dataexchange.model.ListRevisionAssetsRequest
  ): ZStream[Any, AwsError, ReadOnly]
  def listRevisionAssetsPaginated(
      request: zio.aws.dataexchange.model.ListRevisionAssetsRequest
  ): IO[
    AwsError,
    zio.aws.dataexchange.model.ListRevisionAssetsResponse.ReadOnly
  ]
  def createRevision(
      request: zio.aws.dataexchange.model.CreateRevisionRequest
  ): IO[AwsError, zio.aws.dataexchange.model.CreateRevisionResponse.ReadOnly]
  def updateAsset(
      request: zio.aws.dataexchange.model.UpdateAssetRequest
  ): IO[AwsError, zio.aws.dataexchange.model.UpdateAssetResponse.ReadOnly]
  def getDataSet(
      request: zio.aws.dataexchange.model.GetDataSetRequest
  ): IO[AwsError, zio.aws.dataexchange.model.GetDataSetResponse.ReadOnly]
}
object DataExchange {
  val live: ZLayer[AwsConfig, java.lang.Throwable, DataExchange] = customized(
    identity
  )
  def customized(
      customization: DataExchangeAsyncClientBuilder => DataExchangeAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, DataExchange] = managed(
    customization
  ).toLayer
  def managed(
      customization: DataExchangeAsyncClientBuilder => DataExchangeAsyncClientBuilder
  ): ZManaged[AwsConfig, java.lang.Throwable, DataExchange] = for (
    awsConfig <- ZManaged.service[AwsConfig];
    executor <- ZIO.executor.toManaged;
    builder = DataExchangeAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[DataExchangeAsyncClient, DataExchangeAsyncClientBuilder](
        builder
      )
      .toManaged;
    b1 <- awsConfig
      .configureHttpClient[
        DataExchangeAsyncClient,
        DataExchangeAsyncClientBuilder
      ](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      )
      .toManaged; client <- zio.ZIO(customization(b1).build()).toManaged
  )
    yield new DataExchangeImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class DataExchangeImpl[R](
      override val api: DataExchangeAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends DataExchange
      with AwsServiceBase[R] {
    override val serviceName: String = "DataExchange"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): DataExchangeImpl[R1] = new DataExchangeImpl(api, newAspect, r)
    def startJob(
        request: zio.aws.dataexchange.model.StartJobRequest
    ): IO[AwsError, zio.aws.dataexchange.model.StartJobResponse.ReadOnly] =
      asyncRequestResponse[StartJobRequest, StartJobResponse](
        "startJob",
        api.startJob
      )(request.buildAwsValue())
        .map(zio.aws.dataexchange.model.StartJobResponse.wrap)
        .provideEnvironment(r)
    def listDataSetRevisions(
        request: zio.aws.dataexchange.model.ListDataSetRevisionsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.dataexchange.model.RevisionEntry.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListDataSetRevisionsRequest,
      ListDataSetRevisionsResponse,
      RevisionEntry
    ](
      "listDataSetRevisions",
      api.listDataSetRevisions,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.revisions().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.dataexchange.model.RevisionEntry.wrap(item))
      .provideEnvironment(r)
    def listDataSetRevisionsPaginated(
        request: zio.aws.dataexchange.model.ListDataSetRevisionsRequest
    ): IO[
      AwsError,
      zio.aws.dataexchange.model.ListDataSetRevisionsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListDataSetRevisionsRequest,
      ListDataSetRevisionsResponse
    ]("listDataSetRevisions", api.listDataSetRevisions)(request.buildAwsValue())
      .map(zio.aws.dataexchange.model.ListDataSetRevisionsResponse.wrap)
      .provideEnvironment(r)
    def deleteDataSet(
        request: zio.aws.dataexchange.model.DeleteDataSetRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DeleteDataSetRequest, DeleteDataSetResponse](
        "deleteDataSet",
        api.deleteDataSet
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def createJob(
        request: zio.aws.dataexchange.model.CreateJobRequest
    ): IO[AwsError, zio.aws.dataexchange.model.CreateJobResponse.ReadOnly] =
      asyncRequestResponse[CreateJobRequest, CreateJobResponse](
        "createJob",
        api.createJob
      )(request.buildAwsValue())
        .map(zio.aws.dataexchange.model.CreateJobResponse.wrap)
        .provideEnvironment(r)
    def cancelJob(
        request: zio.aws.dataexchange.model.CancelJobRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[CancelJobRequest, CancelJobResponse](
        "cancelJob",
        api.cancelJob
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def listDataSets(
        request: zio.aws.dataexchange.model.ListDataSetsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.dataexchange.model.DataSetEntry.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListDataSetsRequest,
      ListDataSetsResponse,
      DataSetEntry
    ](
      "listDataSets",
      api.listDataSets,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.dataSets().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.dataexchange.model.DataSetEntry.wrap(item))
      .provideEnvironment(r)
    def listDataSetsPaginated(
        request: zio.aws.dataexchange.model.ListDataSetsRequest
    ): IO[AwsError, zio.aws.dataexchange.model.ListDataSetsResponse.ReadOnly] =
      asyncRequestResponse[ListDataSetsRequest, ListDataSetsResponse](
        "listDataSets",
        api.listDataSets
      )(request.buildAwsValue())
        .map(zio.aws.dataexchange.model.ListDataSetsResponse.wrap)
        .provideEnvironment(r)
    def createEventAction(
        request: zio.aws.dataexchange.model.CreateEventActionRequest
    ): IO[
      AwsError,
      zio.aws.dataexchange.model.CreateEventActionResponse.ReadOnly
    ] =
      asyncRequestResponse[CreateEventActionRequest, CreateEventActionResponse](
        "createEventAction",
        api.createEventAction
      )(request.buildAwsValue())
        .map(zio.aws.dataexchange.model.CreateEventActionResponse.wrap)
        .provideEnvironment(r)
    def updateEventAction(
        request: zio.aws.dataexchange.model.UpdateEventActionRequest
    ): IO[
      AwsError,
      zio.aws.dataexchange.model.UpdateEventActionResponse.ReadOnly
    ] =
      asyncRequestResponse[UpdateEventActionRequest, UpdateEventActionResponse](
        "updateEventAction",
        api.updateEventAction
      )(request.buildAwsValue())
        .map(zio.aws.dataexchange.model.UpdateEventActionResponse.wrap)
        .provideEnvironment(r)
    def listEventActions(
        request: zio.aws.dataexchange.model.ListEventActionsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.dataexchange.model.EventActionEntry.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListEventActionsRequest,
      ListEventActionsResponse,
      EventActionEntry
    ](
      "listEventActions",
      api.listEventActions,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.eventActions().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.dataexchange.model.EventActionEntry.wrap(item))
      .provideEnvironment(r)
    def listEventActionsPaginated(
        request: zio.aws.dataexchange.model.ListEventActionsRequest
    ): IO[
      AwsError,
      zio.aws.dataexchange.model.ListEventActionsResponse.ReadOnly
    ] = asyncRequestResponse[ListEventActionsRequest, ListEventActionsResponse](
      "listEventActions",
      api.listEventActions
    )(request.buildAwsValue())
      .map(zio.aws.dataexchange.model.ListEventActionsResponse.wrap)
      .provideEnvironment(r)
    def deleteEventAction(
        request: zio.aws.dataexchange.model.DeleteEventActionRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DeleteEventActionRequest, DeleteEventActionResponse](
        "deleteEventAction",
        api.deleteEventAction
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def getEventAction(
        request: zio.aws.dataexchange.model.GetEventActionRequest
    ): IO[
      AwsError,
      zio.aws.dataexchange.model.GetEventActionResponse.ReadOnly
    ] = asyncRequestResponse[GetEventActionRequest, GetEventActionResponse](
      "getEventAction",
      api.getEventAction
    )(request.buildAwsValue())
      .map(zio.aws.dataexchange.model.GetEventActionResponse.wrap)
      .provideEnvironment(r)
    def updateRevision(
        request: zio.aws.dataexchange.model.UpdateRevisionRequest
    ): IO[
      AwsError,
      zio.aws.dataexchange.model.UpdateRevisionResponse.ReadOnly
    ] = asyncRequestResponse[UpdateRevisionRequest, UpdateRevisionResponse](
      "updateRevision",
      api.updateRevision
    )(request.buildAwsValue())
      .map(zio.aws.dataexchange.model.UpdateRevisionResponse.wrap)
      .provideEnvironment(r)
    def createDataSet(
        request: zio.aws.dataexchange.model.CreateDataSetRequest
    ): IO[AwsError, zio.aws.dataexchange.model.CreateDataSetResponse.ReadOnly] =
      asyncRequestResponse[CreateDataSetRequest, CreateDataSetResponse](
        "createDataSet",
        api.createDataSet
      )(request.buildAwsValue())
        .map(zio.aws.dataexchange.model.CreateDataSetResponse.wrap)
        .provideEnvironment(r)
    def untagResource(
        request: zio.aws.dataexchange.model.UntagResourceRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[UntagResourceRequest, UntagResourceResponse](
        "untagResource",
        api.untagResource
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def deleteRevision(
        request: zio.aws.dataexchange.model.DeleteRevisionRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DeleteRevisionRequest, DeleteRevisionResponse](
        "deleteRevision",
        api.deleteRevision
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def getJob(
        request: zio.aws.dataexchange.model.GetJobRequest
    ): IO[AwsError, zio.aws.dataexchange.model.GetJobResponse.ReadOnly] =
      asyncRequestResponse[GetJobRequest, GetJobResponse]("getJob", api.getJob)(
        request.buildAwsValue()
      ).map(zio.aws.dataexchange.model.GetJobResponse.wrap)
        .provideEnvironment(r)
    def getAsset(
        request: zio.aws.dataexchange.model.GetAssetRequest
    ): IO[AwsError, zio.aws.dataexchange.model.GetAssetResponse.ReadOnly] =
      asyncRequestResponse[GetAssetRequest, GetAssetResponse](
        "getAsset",
        api.getAsset
      )(request.buildAwsValue())
        .map(zio.aws.dataexchange.model.GetAssetResponse.wrap)
        .provideEnvironment(r)
    def getRevision(
        request: zio.aws.dataexchange.model.GetRevisionRequest
    ): IO[AwsError, zio.aws.dataexchange.model.GetRevisionResponse.ReadOnly] =
      asyncRequestResponse[GetRevisionRequest, GetRevisionResponse](
        "getRevision",
        api.getRevision
      )(request.buildAwsValue())
        .map(zio.aws.dataexchange.model.GetRevisionResponse.wrap)
        .provideEnvironment(r)
    def deleteAsset(
        request: zio.aws.dataexchange.model.DeleteAssetRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DeleteAssetRequest, DeleteAssetResponse](
        "deleteAsset",
        api.deleteAsset
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def updateDataSet(
        request: zio.aws.dataexchange.model.UpdateDataSetRequest
    ): IO[AwsError, zio.aws.dataexchange.model.UpdateDataSetResponse.ReadOnly] =
      asyncRequestResponse[UpdateDataSetRequest, UpdateDataSetResponse](
        "updateDataSet",
        api.updateDataSet
      )(request.buildAwsValue())
        .map(zio.aws.dataexchange.model.UpdateDataSetResponse.wrap)
        .provideEnvironment(r)
    def listTagsForResource(
        request: zio.aws.dataexchange.model.ListTagsForResourceRequest
    ): IO[
      AwsError,
      zio.aws.dataexchange.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.dataexchange.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def listJobs(
        request: zio.aws.dataexchange.model.ListJobsRequest
    ): ZStream[Any, AwsError, zio.aws.dataexchange.model.JobEntry.ReadOnly] =
      asyncSimplePaginatedRequest[ListJobsRequest, ListJobsResponse, JobEntry](
        "listJobs",
        api.listJobs,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.jobs().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.dataexchange.model.JobEntry.wrap(item))
        .provideEnvironment(r)
    def listJobsPaginated(
        request: zio.aws.dataexchange.model.ListJobsRequest
    ): IO[AwsError, zio.aws.dataexchange.model.ListJobsResponse.ReadOnly] =
      asyncRequestResponse[ListJobsRequest, ListJobsResponse](
        "listJobs",
        api.listJobs
      )(request.buildAwsValue())
        .map(zio.aws.dataexchange.model.ListJobsResponse.wrap)
        .provideEnvironment(r)
    def tagResource(
        request: zio.aws.dataexchange.model.TagResourceRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[TagResourceRequest, TagResourceResponse](
        "tagResource",
        api.tagResource
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def listRevisionAssets(
        request: zio.aws.dataexchange.model.ListRevisionAssetsRequest
    ): ZStream[Any, AwsError, ReadOnly] = asyncSimplePaginatedRequest[
      ListRevisionAssetsRequest,
      ListRevisionAssetsResponse,
      AssetEntry
    ](
      "listRevisionAssets",
      api.listRevisionAssets,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.assets().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.dataexchange.model.AssetEntry.wrap(item))
      .provideEnvironment(r)
    def listRevisionAssetsPaginated(
        request: zio.aws.dataexchange.model.ListRevisionAssetsRequest
    ): IO[
      AwsError,
      zio.aws.dataexchange.model.ListRevisionAssetsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListRevisionAssetsRequest,
      ListRevisionAssetsResponse
    ]("listRevisionAssets", api.listRevisionAssets)(request.buildAwsValue())
      .map(zio.aws.dataexchange.model.ListRevisionAssetsResponse.wrap)
      .provideEnvironment(r)
    def createRevision(
        request: zio.aws.dataexchange.model.CreateRevisionRequest
    ): IO[
      AwsError,
      zio.aws.dataexchange.model.CreateRevisionResponse.ReadOnly
    ] = asyncRequestResponse[CreateRevisionRequest, CreateRevisionResponse](
      "createRevision",
      api.createRevision
    )(request.buildAwsValue())
      .map(zio.aws.dataexchange.model.CreateRevisionResponse.wrap)
      .provideEnvironment(r)
    def updateAsset(
        request: zio.aws.dataexchange.model.UpdateAssetRequest
    ): IO[AwsError, zio.aws.dataexchange.model.UpdateAssetResponse.ReadOnly] =
      asyncRequestResponse[UpdateAssetRequest, UpdateAssetResponse](
        "updateAsset",
        api.updateAsset
      )(request.buildAwsValue())
        .map(zio.aws.dataexchange.model.UpdateAssetResponse.wrap)
        .provideEnvironment(r)
    def getDataSet(
        request: zio.aws.dataexchange.model.GetDataSetRequest
    ): IO[AwsError, zio.aws.dataexchange.model.GetDataSetResponse.ReadOnly] =
      asyncRequestResponse[GetDataSetRequest, GetDataSetResponse](
        "getDataSet",
        api.getDataSet
      )(request.buildAwsValue())
        .map(zio.aws.dataexchange.model.GetDataSetResponse.wrap)
        .provideEnvironment(r)
  }
  def startJob(request: zio.aws.dataexchange.model.StartJobRequest): ZIO[
    zio.aws.dataexchange.DataExchange,
    AwsError,
    zio.aws.dataexchange.model.StartJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startJob(request))
  def listDataSetRevisions(
      request: zio.aws.dataexchange.model.ListDataSetRevisionsRequest
  ): ZStream[
    zio.aws.dataexchange.DataExchange,
    AwsError,
    zio.aws.dataexchange.model.RevisionEntry.ReadOnly
  ] = ZStream.serviceWithStream(_.listDataSetRevisions(request))
  def listDataSetRevisionsPaginated(
      request: zio.aws.dataexchange.model.ListDataSetRevisionsRequest
  ): ZIO[
    zio.aws.dataexchange.DataExchange,
    AwsError,
    zio.aws.dataexchange.model.ListDataSetRevisionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDataSetRevisionsPaginated(request))
  def deleteDataSet(
      request: zio.aws.dataexchange.model.DeleteDataSetRequest
  ): ZIO[zio.aws.dataexchange.DataExchange, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteDataSet(request))
  def createJob(request: zio.aws.dataexchange.model.CreateJobRequest): ZIO[
    zio.aws.dataexchange.DataExchange,
    AwsError,
    zio.aws.dataexchange.model.CreateJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createJob(request))
  def cancelJob(
      request: zio.aws.dataexchange.model.CancelJobRequest
  ): ZIO[zio.aws.dataexchange.DataExchange, AwsError, Unit] =
    ZIO.serviceWithZIO(_.cancelJob(request))
  def listDataSets(
      request: zio.aws.dataexchange.model.ListDataSetsRequest
  ): ZStream[
    zio.aws.dataexchange.DataExchange,
    AwsError,
    zio.aws.dataexchange.model.DataSetEntry.ReadOnly
  ] = ZStream.serviceWithStream(_.listDataSets(request))
  def listDataSetsPaginated(
      request: zio.aws.dataexchange.model.ListDataSetsRequest
  ): ZIO[
    zio.aws.dataexchange.DataExchange,
    AwsError,
    zio.aws.dataexchange.model.ListDataSetsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDataSetsPaginated(request))
  def createEventAction(
      request: zio.aws.dataexchange.model.CreateEventActionRequest
  ): ZIO[
    zio.aws.dataexchange.DataExchange,
    AwsError,
    zio.aws.dataexchange.model.CreateEventActionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createEventAction(request))
  def updateEventAction(
      request: zio.aws.dataexchange.model.UpdateEventActionRequest
  ): ZIO[
    zio.aws.dataexchange.DataExchange,
    AwsError,
    zio.aws.dataexchange.model.UpdateEventActionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateEventAction(request))
  def listEventActions(
      request: zio.aws.dataexchange.model.ListEventActionsRequest
  ): ZStream[
    zio.aws.dataexchange.DataExchange,
    AwsError,
    zio.aws.dataexchange.model.EventActionEntry.ReadOnly
  ] = ZStream.serviceWithStream(_.listEventActions(request))
  def listEventActionsPaginated(
      request: zio.aws.dataexchange.model.ListEventActionsRequest
  ): ZIO[
    zio.aws.dataexchange.DataExchange,
    AwsError,
    zio.aws.dataexchange.model.ListEventActionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listEventActionsPaginated(request))
  def deleteEventAction(
      request: zio.aws.dataexchange.model.DeleteEventActionRequest
  ): ZIO[zio.aws.dataexchange.DataExchange, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteEventAction(request))
  def getEventAction(
      request: zio.aws.dataexchange.model.GetEventActionRequest
  ): ZIO[
    zio.aws.dataexchange.DataExchange,
    AwsError,
    zio.aws.dataexchange.model.GetEventActionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getEventAction(request))
  def updateRevision(
      request: zio.aws.dataexchange.model.UpdateRevisionRequest
  ): ZIO[
    zio.aws.dataexchange.DataExchange,
    AwsError,
    zio.aws.dataexchange.model.UpdateRevisionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateRevision(request))
  def createDataSet(
      request: zio.aws.dataexchange.model.CreateDataSetRequest
  ): ZIO[
    zio.aws.dataexchange.DataExchange,
    AwsError,
    zio.aws.dataexchange.model.CreateDataSetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDataSet(request))
  def untagResource(
      request: zio.aws.dataexchange.model.UntagResourceRequest
  ): ZIO[zio.aws.dataexchange.DataExchange, AwsError, Unit] =
    ZIO.serviceWithZIO(_.untagResource(request))
  def deleteRevision(
      request: zio.aws.dataexchange.model.DeleteRevisionRequest
  ): ZIO[zio.aws.dataexchange.DataExchange, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteRevision(request))
  def getJob(request: zio.aws.dataexchange.model.GetJobRequest): ZIO[
    zio.aws.dataexchange.DataExchange,
    AwsError,
    zio.aws.dataexchange.model.GetJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getJob(request))
  def getAsset(request: zio.aws.dataexchange.model.GetAssetRequest): ZIO[
    zio.aws.dataexchange.DataExchange,
    AwsError,
    zio.aws.dataexchange.model.GetAssetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getAsset(request))
  def getRevision(request: zio.aws.dataexchange.model.GetRevisionRequest): ZIO[
    zio.aws.dataexchange.DataExchange,
    AwsError,
    zio.aws.dataexchange.model.GetRevisionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getRevision(request))
  def deleteAsset(
      request: zio.aws.dataexchange.model.DeleteAssetRequest
  ): ZIO[zio.aws.dataexchange.DataExchange, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteAsset(request))
  def updateDataSet(
      request: zio.aws.dataexchange.model.UpdateDataSetRequest
  ): ZIO[
    zio.aws.dataexchange.DataExchange,
    AwsError,
    zio.aws.dataexchange.model.UpdateDataSetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateDataSet(request))
  def listTagsForResource(
      request: zio.aws.dataexchange.model.ListTagsForResourceRequest
  ): ZIO[
    zio.aws.dataexchange.DataExchange,
    AwsError,
    zio.aws.dataexchange.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def listJobs(request: zio.aws.dataexchange.model.ListJobsRequest): ZStream[
    zio.aws.dataexchange.DataExchange,
    AwsError,
    zio.aws.dataexchange.model.JobEntry.ReadOnly
  ] = ZStream.serviceWithStream(_.listJobs(request))
  def listJobsPaginated(
      request: zio.aws.dataexchange.model.ListJobsRequest
  ): ZIO[
    zio.aws.dataexchange.DataExchange,
    AwsError,
    zio.aws.dataexchange.model.ListJobsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listJobsPaginated(request))
  def tagResource(
      request: zio.aws.dataexchange.model.TagResourceRequest
  ): ZIO[zio.aws.dataexchange.DataExchange, AwsError, Unit] =
    ZIO.serviceWithZIO(_.tagResource(request))
  def listRevisionAssets(
      request: zio.aws.dataexchange.model.ListRevisionAssetsRequest
  ): ZStream[zio.aws.dataexchange.DataExchange, AwsError, ReadOnly] =
    ZStream.serviceWithStream(_.listRevisionAssets(request))
  def listRevisionAssetsPaginated(
      request: zio.aws.dataexchange.model.ListRevisionAssetsRequest
  ): ZIO[
    zio.aws.dataexchange.DataExchange,
    AwsError,
    zio.aws.dataexchange.model.ListRevisionAssetsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listRevisionAssetsPaginated(request))
  def createRevision(
      request: zio.aws.dataexchange.model.CreateRevisionRequest
  ): ZIO[
    zio.aws.dataexchange.DataExchange,
    AwsError,
    zio.aws.dataexchange.model.CreateRevisionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createRevision(request))
  def updateAsset(request: zio.aws.dataexchange.model.UpdateAssetRequest): ZIO[
    zio.aws.dataexchange.DataExchange,
    AwsError,
    zio.aws.dataexchange.model.UpdateAssetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateAsset(request))
  def getDataSet(request: zio.aws.dataexchange.model.GetDataSetRequest): ZIO[
    zio.aws.dataexchange.DataExchange,
    AwsError,
    zio.aws.dataexchange.model.GetDataSetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDataSet(request))
}
