package zio.aws.dataexchange.model
import zio.aws.dataexchange.model.primitives.{
  AssetName,
  __stringMin24Max24PatternAZaZ094AZaZ092AZaZ093,
  __string,
  Timestamp,
  Id
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class ImportAssetFromSignedUrlResponseDetails(
    assetName: AssetName,
    dataSetId: Id,
    md5Hash: Option[__stringMin24Max24PatternAZaZ094AZaZ092AZaZ093] = None,
    revisionId: Id,
    signedUrl: Option[__string] = None,
    signedUrlExpiresAt: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dataexchange.model.ImportAssetFromSignedUrlResponseDetails = {
    import ImportAssetFromSignedUrlResponseDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dataexchange.model.ImportAssetFromSignedUrlResponseDetails
      .builder()
      .assetName(AssetName.unwrap(assetName): java.lang.String)
      .dataSetId(Id.unwrap(dataSetId): java.lang.String)
      .optionallyWith(md5Hash.map(value => value: java.lang.String))(_.md5Hash)
      .revisionId(Id.unwrap(revisionId): java.lang.String)
      .optionallyWith(signedUrl.map(value => value: java.lang.String))(
        _.signedUrl
      )
      .optionallyWith(
        signedUrlExpiresAt.map(value => Timestamp.unwrap(value): Instant)
      )(_.signedUrlExpiresAt)
      .build()
  }
  def asReadOnly
      : zio.aws.dataexchange.model.ImportAssetFromSignedUrlResponseDetails.ReadOnly =
    zio.aws.dataexchange.model.ImportAssetFromSignedUrlResponseDetails
      .wrap(buildAwsValue())
}
object ImportAssetFromSignedUrlResponseDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dataexchange.model.ImportAssetFromSignedUrlResponseDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.dataexchange.model.ImportAssetFromSignedUrlResponseDetails =
      zio.aws.dataexchange.model.ImportAssetFromSignedUrlResponseDetails(
        assetName,
        dataSetId,
        md5Hash.map(value => value),
        revisionId,
        signedUrl.map(value => value),
        signedUrlExpiresAt.map(value => value)
      )
    def assetName: AssetName
    def dataSetId: Id
    def md5Hash: Option[__stringMin24Max24PatternAZaZ094AZaZ092AZaZ093]
    def revisionId: Id
    def signedUrl: Option[__string]
    def signedUrlExpiresAt: Option[Timestamp]
    def getAssetName: ZIO[Any, Nothing, AssetName] = ZIO.succeed(assetName)
    def getDataSetId: ZIO[Any, Nothing, Id] = ZIO.succeed(dataSetId)
    def getMd5Hash
        : ZIO[Any, AwsError, __stringMin24Max24PatternAZaZ094AZaZ092AZaZ093] =
      AwsError.unwrapOptionField("md5Hash", md5Hash)
    def getRevisionId: ZIO[Any, Nothing, Id] = ZIO.succeed(revisionId)
    def getSignedUrl: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("signedUrl", signedUrl)
    def getSignedUrlExpiresAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("signedUrlExpiresAt", signedUrlExpiresAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dataexchange.model.ImportAssetFromSignedUrlResponseDetails
  ) extends zio.aws.dataexchange.model.ImportAssetFromSignedUrlResponseDetails.ReadOnly {
    override val assetName: AssetName =
      zio.aws.dataexchange.model.primitives.AssetName(impl.assetName())
    override val dataSetId: Id =
      zio.aws.dataexchange.model.primitives.Id(impl.dataSetId())
    override val md5Hash
        : Option[__stringMin24Max24PatternAZaZ094AZaZ092AZaZ093] = scala
      .Option(impl.md5Hash())
      .map(value => value: __stringMin24Max24PatternAZaZ094AZaZ092AZaZ093)
    override val revisionId: Id =
      zio.aws.dataexchange.model.primitives.Id(impl.revisionId())
    override val signedUrl: Option[__string] =
      scala.Option(impl.signedUrl()).map(value => value: __string)
    override val signedUrlExpiresAt: Option[Timestamp] = scala
      .Option(impl.signedUrlExpiresAt())
      .map(value => zio.aws.dataexchange.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dataexchange.model.ImportAssetFromSignedUrlResponseDetails
  ): zio.aws.dataexchange.model.ImportAssetFromSignedUrlResponseDetails.ReadOnly =
    new Wrapper(impl)
}
