package zio.aws.dataexchange.model
import zio.aws.dataexchange.model.primitives.{
  Timestamp,
  __boolean,
  Arn,
  __stringMin0Max16384,
  Id
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class RevisionEntry(
    arn: Arn,
    comment: Option[__stringMin0Max16384] = None,
    createdAt: Timestamp,
    dataSetId: Id,
    finalized: Option[__boolean] = None,
    id: Id,
    sourceId: Option[Id] = None,
    updatedAt: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dataexchange.model.RevisionEntry = {
    import RevisionEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dataexchange.model.RevisionEntry
      .builder()
      .arn(Arn.unwrap(arn): java.lang.String)
      .optionallyWith(
        comment.map(value =>
          __stringMin0Max16384.unwrap(value): java.lang.String
        )
      )(_.comment)
      .createdAt(Timestamp.unwrap(createdAt): Instant)
      .dataSetId(Id.unwrap(dataSetId): java.lang.String)
      .optionallyWith(
        finalized.map(value => __boolean.unwrap(value): java.lang.Boolean)
      )(_.finalized)
      .id(Id.unwrap(id): java.lang.String)
      .optionallyWith(
        sourceId.map(value => Id.unwrap(value): java.lang.String)
      )(_.sourceId)
      .updatedAt(Timestamp.unwrap(updatedAt): Instant)
      .build()
  }
  def asReadOnly: zio.aws.dataexchange.model.RevisionEntry.ReadOnly =
    zio.aws.dataexchange.model.RevisionEntry.wrap(buildAwsValue())
}
object RevisionEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dataexchange.model.RevisionEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dataexchange.model.RevisionEntry =
      zio.aws.dataexchange.model.RevisionEntry(
        arn,
        comment.map(value => value),
        createdAt,
        dataSetId,
        finalized.map(value => value),
        id,
        sourceId.map(value => value),
        updatedAt
      )
    def arn: Arn
    def comment: Option[__stringMin0Max16384]
    def createdAt: Timestamp
    def dataSetId: Id
    def finalized: Option[__boolean]
    def id: Id
    def sourceId: Option[Id]
    def updatedAt: Timestamp
    def getArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(arn)
    def getComment: ZIO[Any, AwsError, __stringMin0Max16384] =
      AwsError.unwrapOptionField("comment", comment)
    def getCreatedAt: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(createdAt)
    def getDataSetId: ZIO[Any, Nothing, Id] = ZIO.succeed(dataSetId)
    def getFinalized: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("finalized", finalized)
    def getId: ZIO[Any, Nothing, Id] = ZIO.succeed(id)
    def getSourceId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("sourceId", sourceId)
    def getUpdatedAt: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(updatedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dataexchange.model.RevisionEntry
  ) extends zio.aws.dataexchange.model.RevisionEntry.ReadOnly {
    override val arn: Arn =
      zio.aws.dataexchange.model.primitives.Arn(impl.arn())
    override val comment: Option[__stringMin0Max16384] = scala
      .Option(impl.comment())
      .map(value =>
        zio.aws.dataexchange.model.primitives.__stringMin0Max16384(value)
      )
    override val createdAt: Timestamp =
      zio.aws.dataexchange.model.primitives.Timestamp(impl.createdAt())
    override val dataSetId: Id =
      zio.aws.dataexchange.model.primitives.Id(impl.dataSetId())
    override val finalized: Option[__boolean] = scala
      .Option(impl.finalized())
      .map(value => zio.aws.dataexchange.model.primitives.__boolean(value))
    override val id: Id = zio.aws.dataexchange.model.primitives.Id(impl.id())
    override val sourceId: Option[Id] = scala
      .Option(impl.sourceId())
      .map(value => zio.aws.dataexchange.model.primitives.Id(value))
    override val updatedAt: Timestamp =
      zio.aws.dataexchange.model.primitives.Timestamp(impl.updatedAt())
  }
  def wrap(
      impl: software.amazon.awssdk.services.dataexchange.model.RevisionEntry
  ): zio.aws.dataexchange.model.RevisionEntry.ReadOnly = new Wrapper(impl)
}
