package zio.aws.dataexchange.model
import zio.aws.dataexchange.model.primitives.{Id, __string}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class RevisionDestinationEntry(
    bucket: __string,
    keyPattern: Option[__string] = None,
    revisionId: Id
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dataexchange.model.RevisionDestinationEntry = {
    import RevisionDestinationEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dataexchange.model.RevisionDestinationEntry
      .builder()
      .bucket(__string.unwrap(bucket): java.lang.String)
      .optionallyWith(
        keyPattern.map(value => __string.unwrap(value): java.lang.String)
      )(_.keyPattern)
      .revisionId(Id.unwrap(revisionId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.dataexchange.model.RevisionDestinationEntry.ReadOnly =
    zio.aws.dataexchange.model.RevisionDestinationEntry.wrap(buildAwsValue())
}
object RevisionDestinationEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dataexchange.model.RevisionDestinationEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dataexchange.model.RevisionDestinationEntry =
      zio.aws.dataexchange.model.RevisionDestinationEntry(
        bucket,
        keyPattern.map(value => value),
        revisionId
      )
    def bucket: __string
    def keyPattern: Option[__string]
    def revisionId: Id
    def getBucket: ZIO[Any, Nothing, __string] = ZIO.succeed(bucket)
    def getKeyPattern: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("keyPattern", keyPattern)
    def getRevisionId: ZIO[Any, Nothing, Id] = ZIO.succeed(revisionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dataexchange.model.RevisionDestinationEntry
  ) extends zio.aws.dataexchange.model.RevisionDestinationEntry.ReadOnly {
    override val bucket: __string =
      zio.aws.dataexchange.model.primitives.__string(impl.bucket())
    override val keyPattern: Option[__string] = scala
      .Option(impl.keyPattern())
      .map(value => zio.aws.dataexchange.model.primitives.__string(value))
    override val revisionId: Id =
      zio.aws.dataexchange.model.primitives.Id(impl.revisionId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.dataexchange.model.RevisionDestinationEntry
  ): zio.aws.dataexchange.model.RevisionDestinationEntry.ReadOnly = new Wrapper(
    impl
  )
}
