package zio.aws.dataexchange.model
import java.lang.Integer
import zio.aws.dataexchange.model.primitives.{MaxResults, __string}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListJobsRequest(
    dataSetId: Option[__string] = None,
    maxResults: Option[MaxResults] = None,
    nextToken: Option[__string] = None,
    revisionId: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dataexchange.model.ListJobsRequest = {
    import ListJobsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dataexchange.model.ListJobsRequest
      .builder()
      .optionallyWith(
        dataSetId.map(value => __string.unwrap(value): java.lang.String)
      )(_.dataSetId)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => __string.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        revisionId.map(value => __string.unwrap(value): java.lang.String)
      )(_.revisionId)
      .build()
  }
  def asReadOnly: zio.aws.dataexchange.model.ListJobsRequest.ReadOnly =
    zio.aws.dataexchange.model.ListJobsRequest.wrap(buildAwsValue())
}
object ListJobsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dataexchange.model.ListJobsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dataexchange.model.ListJobsRequest =
      zio.aws.dataexchange.model.ListJobsRequest(
        dataSetId.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value),
        revisionId.map(value => value)
      )
    def dataSetId: Option[__string]
    def maxResults: Option[MaxResults]
    def nextToken: Option[__string]
    def revisionId: Option[__string]
    def getDataSetId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("dataSetId", dataSetId)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getRevisionId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("revisionId", revisionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dataexchange.model.ListJobsRequest
  ) extends zio.aws.dataexchange.model.ListJobsRequest.ReadOnly {
    override val dataSetId: Option[__string] = scala
      .Option(impl.dataSetId())
      .map(value => zio.aws.dataexchange.model.primitives.__string(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.dataexchange.model.primitives.MaxResults(value))
    override val nextToken: Option[__string] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.dataexchange.model.primitives.__string(value))
    override val revisionId: Option[__string] = scala
      .Option(impl.revisionId())
      .map(value => zio.aws.dataexchange.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dataexchange.model.ListJobsRequest
  ): zio.aws.dataexchange.model.ListJobsRequest.ReadOnly = new Wrapper(impl)
}
