package zio.aws.dataexchange.model
import java.lang.Integer
import zio.aws.dataexchange.model.primitives.{MaxResults, __string}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListEventActionsRequest(
    eventSourceId: Option[__string] = None,
    maxResults: Option[MaxResults] = None,
    nextToken: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dataexchange.model.ListEventActionsRequest = {
    import ListEventActionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dataexchange.model.ListEventActionsRequest
      .builder()
      .optionallyWith(
        eventSourceId.map(value => __string.unwrap(value): java.lang.String)
      )(_.eventSourceId)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => __string.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.dataexchange.model.ListEventActionsRequest.ReadOnly =
    zio.aws.dataexchange.model.ListEventActionsRequest.wrap(buildAwsValue())
}
object ListEventActionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dataexchange.model.ListEventActionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dataexchange.model.ListEventActionsRequest =
      zio.aws.dataexchange.model.ListEventActionsRequest(
        eventSourceId.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def eventSourceId: Option[__string]
    def maxResults: Option[MaxResults]
    def nextToken: Option[__string]
    def getEventSourceId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("eventSourceId", eventSourceId)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dataexchange.model.ListEventActionsRequest
  ) extends zio.aws.dataexchange.model.ListEventActionsRequest.ReadOnly {
    override val eventSourceId: Option[__string] = scala
      .Option(impl.eventSourceId())
      .map(value => zio.aws.dataexchange.model.primitives.__string(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.dataexchange.model.primitives.MaxResults(value))
    override val nextToken: Option[__string] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.dataexchange.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dataexchange.model.ListEventActionsRequest
  ): zio.aws.dataexchange.model.ListEventActionsRequest.ReadOnly = new Wrapper(
    impl
  )
}
