package zio.aws.dataexchange.model
import java.lang.Integer
import zio.aws.dataexchange.model.primitives.{MaxResults, __string}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListDataSetRevisionsRequest(
    dataSetId: __string,
    maxResults: Option[MaxResults] = None,
    nextToken: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dataexchange.model.ListDataSetRevisionsRequest = {
    import ListDataSetRevisionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dataexchange.model.ListDataSetRevisionsRequest
      .builder()
      .dataSetId(__string.unwrap(dataSetId): java.lang.String)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => __string.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.dataexchange.model.ListDataSetRevisionsRequest.ReadOnly =
    zio.aws.dataexchange.model.ListDataSetRevisionsRequest.wrap(buildAwsValue())
}
object ListDataSetRevisionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dataexchange.model.ListDataSetRevisionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dataexchange.model.ListDataSetRevisionsRequest =
      zio.aws.dataexchange.model.ListDataSetRevisionsRequest(
        dataSetId,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def dataSetId: __string
    def maxResults: Option[MaxResults]
    def nextToken: Option[__string]
    def getDataSetId: ZIO[Any, Nothing, __string] = ZIO.succeed(dataSetId)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dataexchange.model.ListDataSetRevisionsRequest
  ) extends zio.aws.dataexchange.model.ListDataSetRevisionsRequest.ReadOnly {
    override val dataSetId: __string =
      zio.aws.dataexchange.model.primitives.__string(impl.dataSetId())
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.dataexchange.model.primitives.MaxResults(value))
    override val nextToken: Option[__string] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.dataexchange.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dataexchange.model.ListDataSetRevisionsRequest
  ): zio.aws.dataexchange.model.ListDataSetRevisionsRequest.ReadOnly =
    new Wrapper(impl)
}
