package zio.aws.dataexchange.model
import zio.aws.dataexchange.model.primitives.__string
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteAssetRequest(
    assetId: __string,
    dataSetId: __string,
    revisionId: __string
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dataexchange.model.DeleteAssetRequest = {
    import DeleteAssetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dataexchange.model.DeleteAssetRequest
      .builder()
      .assetId(__string.unwrap(assetId): java.lang.String)
      .dataSetId(__string.unwrap(dataSetId): java.lang.String)
      .revisionId(__string.unwrap(revisionId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.dataexchange.model.DeleteAssetRequest.ReadOnly =
    zio.aws.dataexchange.model.DeleteAssetRequest.wrap(buildAwsValue())
}
object DeleteAssetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dataexchange.model.DeleteAssetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dataexchange.model.DeleteAssetRequest =
      zio.aws.dataexchange.model
        .DeleteAssetRequest(assetId, dataSetId, revisionId)
    def assetId: __string
    def dataSetId: __string
    def revisionId: __string
    def getAssetId: ZIO[Any, Nothing, __string] = ZIO.succeed(assetId)
    def getDataSetId: ZIO[Any, Nothing, __string] = ZIO.succeed(dataSetId)
    def getRevisionId: ZIO[Any, Nothing, __string] = ZIO.succeed(revisionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dataexchange.model.DeleteAssetRequest
  ) extends zio.aws.dataexchange.model.DeleteAssetRequest.ReadOnly {
    override val assetId: __string =
      zio.aws.dataexchange.model.primitives.__string(impl.assetId())
    override val dataSetId: __string =
      zio.aws.dataexchange.model.primitives.__string(impl.dataSetId())
    override val revisionId: __string =
      zio.aws.dataexchange.model.primitives.__string(impl.revisionId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.dataexchange.model.DeleteAssetRequest
  ): zio.aws.dataexchange.model.DeleteAssetRequest.ReadOnly = new Wrapper(impl)
}
