package zio.aws.dataexchange.model
import zio.aws.dataexchange.model.primitives.{__string, __stringMin0Max16384}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateRevisionRequest(
    comment: Option[__stringMin0Max16384] = None,
    dataSetId: __string,
    tags: Option[Map[__string, __string]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dataexchange.model.CreateRevisionRequest = {
    import CreateRevisionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dataexchange.model.CreateRevisionRequest
      .builder()
      .optionallyWith(
        comment.map(value =>
          __stringMin0Max16384.unwrap(value): java.lang.String
        )
      )(_.comment)
      .dataSetId(__string.unwrap(dataSetId): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (__string.unwrap(key): java.lang.String) -> (__string
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.dataexchange.model.CreateRevisionRequest.ReadOnly =
    zio.aws.dataexchange.model.CreateRevisionRequest.wrap(buildAwsValue())
}
object CreateRevisionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dataexchange.model.CreateRevisionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dataexchange.model.CreateRevisionRequest =
      zio.aws.dataexchange.model.CreateRevisionRequest(
        comment.map(value => value),
        dataSetId,
        tags.map(value => value)
      )
    def comment: Option[__stringMin0Max16384]
    def dataSetId: __string
    def tags: Option[Map[__string, __string]]
    def getComment: ZIO[Any, AwsError, __stringMin0Max16384] =
      AwsError.unwrapOptionField("comment", comment)
    def getDataSetId: ZIO[Any, Nothing, __string] = ZIO.succeed(dataSetId)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dataexchange.model.CreateRevisionRequest
  ) extends zio.aws.dataexchange.model.CreateRevisionRequest.ReadOnly {
    override val comment: Option[__stringMin0Max16384] = scala
      .Option(impl.comment())
      .map(value =>
        zio.aws.dataexchange.model.primitives.__stringMin0Max16384(value)
      )
    override val dataSetId: __string =
      zio.aws.dataexchange.model.primitives.__string(impl.dataSetId())
    override val tags: Option[Map[__string, __string]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.dataexchange.model.primitives.__string(
              key
            ) -> zio.aws.dataexchange.model.primitives.__string(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dataexchange.model.CreateRevisionRequest
  ): zio.aws.dataexchange.model.CreateRevisionRequest.ReadOnly = new Wrapper(
    impl
  )
}
