package zio.aws.dataexchange.model
import zio.aws.dataexchange.model.primitives.__string
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AutoExportRevisionDestinationEntry(
    bucket: __string,
    keyPattern: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dataexchange.model.AutoExportRevisionDestinationEntry = {
    import AutoExportRevisionDestinationEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dataexchange.model.AutoExportRevisionDestinationEntry
      .builder()
      .bucket(__string.unwrap(bucket): java.lang.String)
      .optionallyWith(
        keyPattern.map(value => __string.unwrap(value): java.lang.String)
      )(_.keyPattern)
      .build()
  }
  def asReadOnly
      : zio.aws.dataexchange.model.AutoExportRevisionDestinationEntry.ReadOnly =
    zio.aws.dataexchange.model.AutoExportRevisionDestinationEntry
      .wrap(buildAwsValue())
}
object AutoExportRevisionDestinationEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dataexchange.model.AutoExportRevisionDestinationEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.dataexchange.model.AutoExportRevisionDestinationEntry =
      zio.aws.dataexchange.model.AutoExportRevisionDestinationEntry(
        bucket,
        keyPattern.map(value => value)
      )
    def bucket: __string
    def keyPattern: Option[__string]
    def getBucket: ZIO[Any, Nothing, __string] = ZIO.succeed(bucket)
    def getKeyPattern: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("keyPattern", keyPattern)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dataexchange.model.AutoExportRevisionDestinationEntry
  ) extends zio.aws.dataexchange.model.AutoExportRevisionDestinationEntry.ReadOnly {
    override val bucket: __string =
      zio.aws.dataexchange.model.primitives.__string(impl.bucket())
    override val keyPattern: Option[__string] = scala
      .Option(impl.keyPattern())
      .map(value => zio.aws.dataexchange.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dataexchange.model.AutoExportRevisionDestinationEntry
  ): zio.aws.dataexchange.model.AutoExportRevisionDestinationEntry.ReadOnly =
    new Wrapper(impl)
}
