package zio.aws.dataexchange.model
import zio.aws.dataexchange.model.primitives.{AssetName, Id, Timestamp, Arn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class AssetEntry(
    arn: Arn,
    assetDetails: zio.aws.dataexchange.model.AssetDetails,
    assetType: zio.aws.dataexchange.model.AssetType,
    createdAt: Timestamp,
    dataSetId: Id,
    id: Id,
    name: AssetName,
    revisionId: Id,
    sourceId: Option[Id] = None,
    updatedAt: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dataexchange.model.AssetEntry = {
    import AssetEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dataexchange.model.AssetEntry
      .builder()
      .arn(Arn.unwrap(arn): java.lang.String)
      .assetDetails(assetDetails.buildAwsValue())
      .assetType(assetType.unwrap)
      .createdAt(Timestamp.unwrap(createdAt): Instant)
      .dataSetId(Id.unwrap(dataSetId): java.lang.String)
      .id(Id.unwrap(id): java.lang.String)
      .name(AssetName.unwrap(name): java.lang.String)
      .revisionId(Id.unwrap(revisionId): java.lang.String)
      .optionallyWith(
        sourceId.map(value => Id.unwrap(value): java.lang.String)
      )(_.sourceId)
      .updatedAt(Timestamp.unwrap(updatedAt): Instant)
      .build()
  }
  def asReadOnly: zio.aws.dataexchange.model.AssetEntry.ReadOnly =
    zio.aws.dataexchange.model.AssetEntry.wrap(buildAwsValue())
}
object AssetEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dataexchange.model.AssetEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dataexchange.model.AssetEntry =
      zio.aws.dataexchange.model.AssetEntry(
        arn,
        assetDetails.asEditable,
        assetType,
        createdAt,
        dataSetId,
        id,
        name,
        revisionId,
        sourceId.map(value => value),
        updatedAt
      )
    def arn: Arn
    def assetDetails: zio.aws.dataexchange.model.AssetDetails.ReadOnly
    def assetType: zio.aws.dataexchange.model.AssetType
    def createdAt: Timestamp
    def dataSetId: Id
    def id: Id
    def name: AssetName
    def revisionId: Id
    def sourceId: Option[Id]
    def updatedAt: Timestamp
    def getArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(arn)
    def getAssetDetails
        : ZIO[Any, Nothing, zio.aws.dataexchange.model.AssetDetails.ReadOnly] =
      ZIO.succeed(assetDetails)
    def getAssetType: ZIO[Any, Nothing, zio.aws.dataexchange.model.AssetType] =
      ZIO.succeed(assetType)
    def getCreatedAt: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(createdAt)
    def getDataSetId: ZIO[Any, Nothing, Id] = ZIO.succeed(dataSetId)
    def getId: ZIO[Any, Nothing, Id] = ZIO.succeed(id)
    def getName: ZIO[Any, Nothing, AssetName] = ZIO.succeed(name)
    def getRevisionId: ZIO[Any, Nothing, Id] = ZIO.succeed(revisionId)
    def getSourceId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("sourceId", sourceId)
    def getUpdatedAt: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(updatedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dataexchange.model.AssetEntry
  ) extends zio.aws.dataexchange.model.AssetEntry.ReadOnly {
    override val arn: Arn =
      zio.aws.dataexchange.model.primitives.Arn(impl.arn())
    override val assetDetails
        : zio.aws.dataexchange.model.AssetDetails.ReadOnly =
      zio.aws.dataexchange.model.AssetDetails.wrap(impl.assetDetails())
    override val assetType: zio.aws.dataexchange.model.AssetType =
      zio.aws.dataexchange.model.AssetType.wrap(impl.assetType())
    override val createdAt: Timestamp =
      zio.aws.dataexchange.model.primitives.Timestamp(impl.createdAt())
    override val dataSetId: Id =
      zio.aws.dataexchange.model.primitives.Id(impl.dataSetId())
    override val id: Id = zio.aws.dataexchange.model.primitives.Id(impl.id())
    override val name: AssetName =
      zio.aws.dataexchange.model.primitives.AssetName(impl.name())
    override val revisionId: Id =
      zio.aws.dataexchange.model.primitives.Id(impl.revisionId())
    override val sourceId: Option[Id] = scala
      .Option(impl.sourceId())
      .map(value => zio.aws.dataexchange.model.primitives.Id(value))
    override val updatedAt: Timestamp =
      zio.aws.dataexchange.model.primitives.Timestamp(impl.updatedAt())
  }
  def wrap(
      impl: software.amazon.awssdk.services.dataexchange.model.AssetEntry
  ): zio.aws.dataexchange.model.AssetEntry.ReadOnly = new Wrapper(impl)
}
