package zio.aws.dataexchange.model
import zio.aws.dataexchange.model.primitives.{
  Timestamp,
  __string,
  ApiDescription
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class ApiGatewayApiAsset(
    apiDescription: Option[ApiDescription] = None,
    apiEndpoint: Option[__string] = None,
    apiId: Option[__string] = None,
    apiKey: Option[__string] = None,
    apiName: Option[__string] = None,
    apiSpecificationDownloadUrl: Option[__string] = None,
    apiSpecificationDownloadUrlExpiresAt: Option[Timestamp] = None,
    protocolType: Option[zio.aws.dataexchange.model.ProtocolType] = None,
    stage: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dataexchange.model.ApiGatewayApiAsset = {
    import ApiGatewayApiAsset.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dataexchange.model.ApiGatewayApiAsset
      .builder()
      .optionallyWith(
        apiDescription.map(value =>
          ApiDescription.unwrap(value): java.lang.String
        )
      )(_.apiDescription)
      .optionallyWith(
        apiEndpoint.map(value => __string.unwrap(value): java.lang.String)
      )(_.apiEndpoint)
      .optionallyWith(
        apiId.map(value => __string.unwrap(value): java.lang.String)
      )(_.apiId)
      .optionallyWith(
        apiKey.map(value => __string.unwrap(value): java.lang.String)
      )(_.apiKey)
      .optionallyWith(
        apiName.map(value => __string.unwrap(value): java.lang.String)
      )(_.apiName)
      .optionallyWith(
        apiSpecificationDownloadUrl.map(value =>
          __string.unwrap(value): java.lang.String
        )
      )(_.apiSpecificationDownloadUrl)
      .optionallyWith(
        apiSpecificationDownloadUrlExpiresAt.map(value =>
          Timestamp.unwrap(value): Instant
        )
      )(_.apiSpecificationDownloadUrlExpiresAt)
      .optionallyWith(protocolType.map(value => value.unwrap))(_.protocolType)
      .optionallyWith(
        stage.map(value => __string.unwrap(value): java.lang.String)
      )(_.stage)
      .build()
  }
  def asReadOnly: zio.aws.dataexchange.model.ApiGatewayApiAsset.ReadOnly =
    zio.aws.dataexchange.model.ApiGatewayApiAsset.wrap(buildAwsValue())
}
object ApiGatewayApiAsset {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dataexchange.model.ApiGatewayApiAsset
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dataexchange.model.ApiGatewayApiAsset =
      zio.aws.dataexchange.model.ApiGatewayApiAsset(
        apiDescription.map(value => value),
        apiEndpoint.map(value => value),
        apiId.map(value => value),
        apiKey.map(value => value),
        apiName.map(value => value),
        apiSpecificationDownloadUrl.map(value => value),
        apiSpecificationDownloadUrlExpiresAt.map(value => value),
        protocolType.map(value => value),
        stage.map(value => value)
      )
    def apiDescription: Option[ApiDescription]
    def apiEndpoint: Option[__string]
    def apiId: Option[__string]
    def apiKey: Option[__string]
    def apiName: Option[__string]
    def apiSpecificationDownloadUrl: Option[__string]
    def apiSpecificationDownloadUrlExpiresAt: Option[Timestamp]
    def protocolType: Option[zio.aws.dataexchange.model.ProtocolType]
    def stage: Option[__string]
    def getApiDescription: ZIO[Any, AwsError, ApiDescription] =
      AwsError.unwrapOptionField("apiDescription", apiDescription)
    def getApiEndpoint: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("apiEndpoint", apiEndpoint)
    def getApiId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("apiId", apiId)
    def getApiKey: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("apiKey", apiKey)
    def getApiName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("apiName", apiName)
    def getApiSpecificationDownloadUrl: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField(
        "apiSpecificationDownloadUrl",
        apiSpecificationDownloadUrl
      )
    def getApiSpecificationDownloadUrlExpiresAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField(
        "apiSpecificationDownloadUrlExpiresAt",
        apiSpecificationDownloadUrlExpiresAt
      )
    def getProtocolType
        : ZIO[Any, AwsError, zio.aws.dataexchange.model.ProtocolType] =
      AwsError.unwrapOptionField("protocolType", protocolType)
    def getStage: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("stage", stage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dataexchange.model.ApiGatewayApiAsset
  ) extends zio.aws.dataexchange.model.ApiGatewayApiAsset.ReadOnly {
    override val apiDescription: Option[ApiDescription] = scala
      .Option(impl.apiDescription())
      .map(value => zio.aws.dataexchange.model.primitives.ApiDescription(value))
    override val apiEndpoint: Option[__string] = scala
      .Option(impl.apiEndpoint())
      .map(value => zio.aws.dataexchange.model.primitives.__string(value))
    override val apiId: Option[__string] = scala
      .Option(impl.apiId())
      .map(value => zio.aws.dataexchange.model.primitives.__string(value))
    override val apiKey: Option[__string] = scala
      .Option(impl.apiKey())
      .map(value => zio.aws.dataexchange.model.primitives.__string(value))
    override val apiName: Option[__string] = scala
      .Option(impl.apiName())
      .map(value => zio.aws.dataexchange.model.primitives.__string(value))
    override val apiSpecificationDownloadUrl: Option[__string] = scala
      .Option(impl.apiSpecificationDownloadUrl())
      .map(value => zio.aws.dataexchange.model.primitives.__string(value))
    override val apiSpecificationDownloadUrlExpiresAt: Option[Timestamp] = scala
      .Option(impl.apiSpecificationDownloadUrlExpiresAt())
      .map(value => zio.aws.dataexchange.model.primitives.Timestamp(value))
    override val protocolType: Option[zio.aws.dataexchange.model.ProtocolType] =
      scala
        .Option(impl.protocolType())
        .map(value => zio.aws.dataexchange.model.ProtocolType.wrap(value))
    override val stage: Option[__string] = scala
      .Option(impl.stage())
      .map(value => zio.aws.dataexchange.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dataexchange.model.ApiGatewayApiAsset
  ): zio.aws.dataexchange.model.ApiGatewayApiAsset.ReadOnly = new Wrapper(impl)
}
