package zio.aws.dataexchange.model
import zio.aws.dataexchange.model.primitives.__string
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateEventActionRequest(
    action: Option[zio.aws.dataexchange.model.Action] = None,
    eventActionId: __string
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dataexchange.model.UpdateEventActionRequest = {
    import UpdateEventActionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dataexchange.model.UpdateEventActionRequest
      .builder()
      .optionallyWith(action.map(value => value.buildAwsValue()))(_.action)
      .eventActionId(__string.unwrap(eventActionId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.dataexchange.model.UpdateEventActionRequest.ReadOnly =
    zio.aws.dataexchange.model.UpdateEventActionRequest.wrap(buildAwsValue())
}
object UpdateEventActionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dataexchange.model.UpdateEventActionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dataexchange.model.UpdateEventActionRequest =
      zio.aws.dataexchange.model.UpdateEventActionRequest(
        action.map(value => value.asEditable),
        eventActionId
      )
    def action: Option[zio.aws.dataexchange.model.Action.ReadOnly]
    def eventActionId: __string
    def getAction
        : ZIO[Any, AwsError, zio.aws.dataexchange.model.Action.ReadOnly] =
      AwsError.unwrapOptionField("action", action)
    def getEventActionId: ZIO[Any, Nothing, __string] =
      ZIO.succeed(eventActionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dataexchange.model.UpdateEventActionRequest
  ) extends zio.aws.dataexchange.model.UpdateEventActionRequest.ReadOnly {
    override val action: Option[zio.aws.dataexchange.model.Action.ReadOnly] =
      scala
        .Option(impl.action())
        .map(value => zio.aws.dataexchange.model.Action.wrap(value))
    override val eventActionId: __string =
      zio.aws.dataexchange.model.primitives.__string(impl.eventActionId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.dataexchange.model.UpdateEventActionRequest
  ): zio.aws.dataexchange.model.UpdateEventActionRequest.ReadOnly = new Wrapper(
    impl
  )
}
