package zio.aws.dataexchange.model
import zio.aws.dataexchange.model.primitives.{Name, Description, __string}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateDataSetRequest(
    dataSetId: __string,
    description: Option[Description] = None,
    name: Option[Name] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dataexchange.model.UpdateDataSetRequest = {
    import UpdateDataSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dataexchange.model.UpdateDataSetRequest
      .builder()
      .dataSetId(__string.unwrap(dataSetId): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .build()
  }
  def asReadOnly: zio.aws.dataexchange.model.UpdateDataSetRequest.ReadOnly =
    zio.aws.dataexchange.model.UpdateDataSetRequest.wrap(buildAwsValue())
}
object UpdateDataSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dataexchange.model.UpdateDataSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dataexchange.model.UpdateDataSetRequest =
      zio.aws.dataexchange.model.UpdateDataSetRequest(
        dataSetId,
        description.map(value => value),
        name.map(value => value)
      )
    def dataSetId: __string
    def description: Option[Description]
    def name: Option[Name]
    def getDataSetId: ZIO[Any, Nothing, __string] = ZIO.succeed(dataSetId)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dataexchange.model.UpdateDataSetRequest
  ) extends zio.aws.dataexchange.model.UpdateDataSetRequest.ReadOnly {
    override val dataSetId: __string =
      zio.aws.dataexchange.model.primitives.__string(impl.dataSetId())
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.dataexchange.model.primitives.Description(value))
    override val name: Option[Name] = scala
      .Option(impl.name())
      .map(value => zio.aws.dataexchange.model.primitives.Name(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dataexchange.model.UpdateDataSetRequest
  ): zio.aws.dataexchange.model.UpdateDataSetRequest.ReadOnly = new Wrapper(
    impl
  )
}
