package zio.aws.dataexchange.model
import zio.aws.dataexchange.model.primitives.Id
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class RevisionPublished(dataSetId: Id) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dataexchange.model.RevisionPublished = {
    import RevisionPublished.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dataexchange.model.RevisionPublished
      .builder()
      .dataSetId(Id.unwrap(dataSetId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.dataexchange.model.RevisionPublished.ReadOnly =
    zio.aws.dataexchange.model.RevisionPublished.wrap(buildAwsValue())
}
object RevisionPublished {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dataexchange.model.RevisionPublished
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dataexchange.model.RevisionPublished =
      zio.aws.dataexchange.model.RevisionPublished(dataSetId)
    def dataSetId: Id
    def getDataSetId: ZIO[Any, Nothing, Id] = ZIO.succeed(dataSetId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dataexchange.model.RevisionPublished
  ) extends zio.aws.dataexchange.model.RevisionPublished.ReadOnly {
    override val dataSetId: Id =
      zio.aws.dataexchange.model.primitives.Id(impl.dataSetId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.dataexchange.model.RevisionPublished
  ): zio.aws.dataexchange.model.RevisionPublished.ReadOnly = new Wrapper(impl)
}
