package zio.aws.dataexchange.model
import java.lang.Integer
import zio.aws.dataexchange.model.primitives.{MaxResults, __string}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListRevisionAssetsRequest(
    dataSetId: __string,
    maxResults: Option[MaxResults] = None,
    nextToken: Option[__string] = None,
    revisionId: __string
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dataexchange.model.ListRevisionAssetsRequest = {
    import ListRevisionAssetsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dataexchange.model.ListRevisionAssetsRequest
      .builder()
      .dataSetId(__string.unwrap(dataSetId): java.lang.String)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => __string.unwrap(value): java.lang.String)
      )(_.nextToken)
      .revisionId(__string.unwrap(revisionId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.dataexchange.model.ListRevisionAssetsRequest.ReadOnly =
    zio.aws.dataexchange.model.ListRevisionAssetsRequest.wrap(buildAwsValue())
}
object ListRevisionAssetsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dataexchange.model.ListRevisionAssetsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dataexchange.model.ListRevisionAssetsRequest =
      zio.aws.dataexchange.model.ListRevisionAssetsRequest(
        dataSetId,
        maxResults.map(value => value),
        nextToken.map(value => value),
        revisionId
      )
    def dataSetId: __string
    def maxResults: Option[MaxResults]
    def nextToken: Option[__string]
    def revisionId: __string
    def getDataSetId: ZIO[Any, Nothing, __string] = ZIO.succeed(dataSetId)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getRevisionId: ZIO[Any, Nothing, __string] = ZIO.succeed(revisionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dataexchange.model.ListRevisionAssetsRequest
  ) extends zio.aws.dataexchange.model.ListRevisionAssetsRequest.ReadOnly {
    override val dataSetId: __string =
      zio.aws.dataexchange.model.primitives.__string(impl.dataSetId())
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.dataexchange.model.primitives.MaxResults(value))
    override val nextToken: Option[__string] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.dataexchange.model.primitives.__string(value))
    override val revisionId: __string =
      zio.aws.dataexchange.model.primitives.__string(impl.revisionId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.dataexchange.model.ListRevisionAssetsRequest
  ): zio.aws.dataexchange.model.ListRevisionAssetsRequest.ReadOnly =
    new Wrapper(impl)
}
