package zio.aws.dataexchange.model
import zio.aws.dataexchange.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListDataSetRevisionsResponse(
    nextToken: Option[NextToken] = None,
    revisions: Option[Iterable[zio.aws.dataexchange.model.RevisionEntry]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dataexchange.model.ListDataSetRevisionsResponse = {
    import ListDataSetRevisionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dataexchange.model.ListDataSetRevisionsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        revisions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.revisions)
      .build()
  }
  def asReadOnly
      : zio.aws.dataexchange.model.ListDataSetRevisionsResponse.ReadOnly =
    zio.aws.dataexchange.model.ListDataSetRevisionsResponse
      .wrap(buildAwsValue())
}
object ListDataSetRevisionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dataexchange.model.ListDataSetRevisionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dataexchange.model.ListDataSetRevisionsResponse =
      zio.aws.dataexchange.model.ListDataSetRevisionsResponse(
        nextToken.map(value => value),
        revisions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Option[NextToken]
    def revisions
        : Option[List[zio.aws.dataexchange.model.RevisionEntry.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getRevisions: ZIO[Any, AwsError, List[
      zio.aws.dataexchange.model.RevisionEntry.ReadOnly
    ]] = AwsError.unwrapOptionField("revisions", revisions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dataexchange.model.ListDataSetRevisionsResponse
  ) extends zio.aws.dataexchange.model.ListDataSetRevisionsResponse.ReadOnly {
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.dataexchange.model.primitives.NextToken(value))
    override val revisions
        : Option[List[zio.aws.dataexchange.model.RevisionEntry.ReadOnly]] =
      scala
        .Option(impl.revisions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.dataexchange.model.RevisionEntry.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dataexchange.model.ListDataSetRevisionsResponse
  ): zio.aws.dataexchange.model.ListDataSetRevisionsResponse.ReadOnly =
    new Wrapper(impl)
}
