package zio.aws.dataexchange.model
import zio.aws.dataexchange.model.primitives.{__string, __double}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class JobError(
    code: zio.aws.dataexchange.model.Code,
    details: Option[zio.aws.dataexchange.model.Details] = None,
    limitName: Option[zio.aws.dataexchange.model.JobErrorLimitName] = None,
    limitValue: Option[__double] = None,
    message: __string,
    resourceId: Option[__string] = None,
    resourceType: Option[zio.aws.dataexchange.model.JobErrorResourceTypes] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dataexchange.model.JobError = {
    import JobError.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dataexchange.model.JobError
      .builder()
      .code(code.unwrap)
      .optionallyWith(details.map(value => value.buildAwsValue()))(_.details)
      .optionallyWith(limitName.map(value => value.unwrap))(_.limitName)
      .optionallyWith(
        limitValue.map(value => __double.unwrap(value): java.lang.Double)
      )(_.limitValue)
      .message(__string.unwrap(message): java.lang.String)
      .optionallyWith(
        resourceId.map(value => __string.unwrap(value): java.lang.String)
      )(_.resourceId)
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .build()
  }
  def asReadOnly: zio.aws.dataexchange.model.JobError.ReadOnly =
    zio.aws.dataexchange.model.JobError.wrap(buildAwsValue())
}
object JobError {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dataexchange.model.JobError
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dataexchange.model.JobError =
      zio.aws.dataexchange.model.JobError(
        code,
        details.map(value => value.asEditable),
        limitName.map(value => value),
        limitValue.map(value => value),
        message,
        resourceId.map(value => value),
        resourceType.map(value => value)
      )
    def code: zio.aws.dataexchange.model.Code
    def details: Option[zio.aws.dataexchange.model.Details.ReadOnly]
    def limitName: Option[zio.aws.dataexchange.model.JobErrorLimitName]
    def limitValue: Option[__double]
    def message: __string
    def resourceId: Option[__string]
    def resourceType: Option[zio.aws.dataexchange.model.JobErrorResourceTypes]
    def getCode: ZIO[Any, Nothing, zio.aws.dataexchange.model.Code] =
      ZIO.succeed(code)
    def getDetails
        : ZIO[Any, AwsError, zio.aws.dataexchange.model.Details.ReadOnly] =
      AwsError.unwrapOptionField("details", details)
    def getLimitName
        : ZIO[Any, AwsError, zio.aws.dataexchange.model.JobErrorLimitName] =
      AwsError.unwrapOptionField("limitName", limitName)
    def getLimitValue: ZIO[Any, AwsError, __double] =
      AwsError.unwrapOptionField("limitValue", limitValue)
    def getMessage: ZIO[Any, Nothing, __string] = ZIO.succeed(message)
    def getResourceId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("resourceId", resourceId)
    def getResourceType
        : ZIO[Any, AwsError, zio.aws.dataexchange.model.JobErrorResourceTypes] =
      AwsError.unwrapOptionField("resourceType", resourceType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dataexchange.model.JobError
  ) extends zio.aws.dataexchange.model.JobError.ReadOnly {
    override val code: zio.aws.dataexchange.model.Code =
      zio.aws.dataexchange.model.Code.wrap(impl.code())
    override val details: Option[zio.aws.dataexchange.model.Details.ReadOnly] =
      scala
        .Option(impl.details())
        .map(value => zio.aws.dataexchange.model.Details.wrap(value))
    override val limitName
        : Option[zio.aws.dataexchange.model.JobErrorLimitName] = scala
      .Option(impl.limitName())
      .map(value => zio.aws.dataexchange.model.JobErrorLimitName.wrap(value))
    override val limitValue: Option[__double] = scala
      .Option(impl.limitValue())
      .map(value => zio.aws.dataexchange.model.primitives.__double(value))
    override val message: __string =
      zio.aws.dataexchange.model.primitives.__string(impl.message())
    override val resourceId: Option[__string] = scala
      .Option(impl.resourceId())
      .map(value => zio.aws.dataexchange.model.primitives.__string(value))
    override val resourceType
        : Option[zio.aws.dataexchange.model.JobErrorResourceTypes] = scala
      .Option(impl.resourceType())
      .map(value =>
        zio.aws.dataexchange.model.JobErrorResourceTypes.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dataexchange.model.JobError
  ): zio.aws.dataexchange.model.JobError.ReadOnly = new Wrapper(impl)
}
