package zio.aws.dataexchange.model
import zio.aws.dataexchange.model.primitives.{
  __stringMin24Max24PatternAZaZ094AZaZ092AZaZ093,
  __string,
  Timestamp,
  Id,
  ApiDescription
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class ImportAssetFromApiGatewayApiResponseDetails(
    apiDescription: Option[ApiDescription] = None,
    apiId: __string,
    apiKey: Option[__string] = None,
    apiName: __string,
    apiSpecificationMd5Hash: __stringMin24Max24PatternAZaZ094AZaZ092AZaZ093,
    apiSpecificationUploadUrl: __string,
    apiSpecificationUploadUrlExpiresAt: Timestamp,
    dataSetId: Id,
    protocolType: zio.aws.dataexchange.model.ProtocolType,
    revisionId: Id,
    stage: __string
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dataexchange.model.ImportAssetFromApiGatewayApiResponseDetails = {
    import ImportAssetFromApiGatewayApiResponseDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dataexchange.model.ImportAssetFromApiGatewayApiResponseDetails
      .builder()
      .optionallyWith(
        apiDescription.map(value =>
          ApiDescription.unwrap(value): java.lang.String
        )
      )(_.apiDescription)
      .apiId(__string.unwrap(apiId): java.lang.String)
      .optionallyWith(
        apiKey.map(value => __string.unwrap(value): java.lang.String)
      )(_.apiKey)
      .apiName(__string.unwrap(apiName): java.lang.String)
      .apiSpecificationMd5Hash(
        __stringMin24Max24PatternAZaZ094AZaZ092AZaZ093.unwrap(
          apiSpecificationMd5Hash
        ): java.lang.String
      )
      .apiSpecificationUploadUrl(
        __string.unwrap(apiSpecificationUploadUrl): java.lang.String
      )
      .apiSpecificationUploadUrlExpiresAt(
        Timestamp.unwrap(apiSpecificationUploadUrlExpiresAt): Instant
      )
      .dataSetId(Id.unwrap(dataSetId): java.lang.String)
      .protocolType(protocolType.unwrap)
      .revisionId(Id.unwrap(revisionId): java.lang.String)
      .stage(__string.unwrap(stage): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.dataexchange.model.ImportAssetFromApiGatewayApiResponseDetails.ReadOnly =
    zio.aws.dataexchange.model.ImportAssetFromApiGatewayApiResponseDetails
      .wrap(buildAwsValue())
}
object ImportAssetFromApiGatewayApiResponseDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dataexchange.model.ImportAssetFromApiGatewayApiResponseDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.dataexchange.model.ImportAssetFromApiGatewayApiResponseDetails =
      zio.aws.dataexchange.model.ImportAssetFromApiGatewayApiResponseDetails(
        apiDescription.map(value => value),
        apiId,
        apiKey.map(value => value),
        apiName,
        apiSpecificationMd5Hash,
        apiSpecificationUploadUrl,
        apiSpecificationUploadUrlExpiresAt,
        dataSetId,
        protocolType,
        revisionId,
        stage
      )
    def apiDescription: Option[ApiDescription]
    def apiId: __string
    def apiKey: Option[__string]
    def apiName: __string
    def apiSpecificationMd5Hash: __stringMin24Max24PatternAZaZ094AZaZ092AZaZ093
    def apiSpecificationUploadUrl: __string
    def apiSpecificationUploadUrlExpiresAt: Timestamp
    def dataSetId: Id
    def protocolType: zio.aws.dataexchange.model.ProtocolType
    def revisionId: Id
    def stage: __string
    def getApiDescription: ZIO[Any, AwsError, ApiDescription] =
      AwsError.unwrapOptionField("apiDescription", apiDescription)
    def getApiId: ZIO[Any, Nothing, __string] = ZIO.succeed(apiId)
    def getApiKey: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("apiKey", apiKey)
    def getApiName: ZIO[Any, Nothing, __string] = ZIO.succeed(apiName)
    def getApiSpecificationMd5Hash
        : ZIO[Any, Nothing, __stringMin24Max24PatternAZaZ094AZaZ092AZaZ093] =
      ZIO.succeed(apiSpecificationMd5Hash)
    def getApiSpecificationUploadUrl: ZIO[Any, Nothing, __string] =
      ZIO.succeed(apiSpecificationUploadUrl)
    def getApiSpecificationUploadUrlExpiresAt: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(apiSpecificationUploadUrlExpiresAt)
    def getDataSetId: ZIO[Any, Nothing, Id] = ZIO.succeed(dataSetId)
    def getProtocolType
        : ZIO[Any, Nothing, zio.aws.dataexchange.model.ProtocolType] =
      ZIO.succeed(protocolType)
    def getRevisionId: ZIO[Any, Nothing, Id] = ZIO.succeed(revisionId)
    def getStage: ZIO[Any, Nothing, __string] = ZIO.succeed(stage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dataexchange.model.ImportAssetFromApiGatewayApiResponseDetails
  ) extends zio.aws.dataexchange.model.ImportAssetFromApiGatewayApiResponseDetails.ReadOnly {
    override val apiDescription: Option[ApiDescription] = scala
      .Option(impl.apiDescription())
      .map(value => zio.aws.dataexchange.model.primitives.ApiDescription(value))
    override val apiId: __string =
      zio.aws.dataexchange.model.primitives.__string(impl.apiId())
    override val apiKey: Option[__string] = scala
      .Option(impl.apiKey())
      .map(value => zio.aws.dataexchange.model.primitives.__string(value))
    override val apiName: __string =
      zio.aws.dataexchange.model.primitives.__string(impl.apiName())
    override val apiSpecificationMd5Hash
        : __stringMin24Max24PatternAZaZ094AZaZ092AZaZ093 =
      zio.aws.dataexchange.model.primitives
        .__stringMin24Max24PatternAZaZ094AZaZ092AZaZ093(
          impl.apiSpecificationMd5Hash()
        )
    override val apiSpecificationUploadUrl: __string =
      zio.aws.dataexchange.model.primitives
        .__string(impl.apiSpecificationUploadUrl())
    override val apiSpecificationUploadUrlExpiresAt: Timestamp =
      zio.aws.dataexchange.model.primitives
        .Timestamp(impl.apiSpecificationUploadUrlExpiresAt())
    override val dataSetId: Id =
      zio.aws.dataexchange.model.primitives.Id(impl.dataSetId())
    override val protocolType: zio.aws.dataexchange.model.ProtocolType =
      zio.aws.dataexchange.model.ProtocolType.wrap(impl.protocolType())
    override val revisionId: Id =
      zio.aws.dataexchange.model.primitives.Id(impl.revisionId())
    override val stage: __string =
      zio.aws.dataexchange.model.primitives.__string(impl.stage())
  }
  def wrap(
      impl: software.amazon.awssdk.services.dataexchange.model.ImportAssetFromApiGatewayApiResponseDetails
  ): zio.aws.dataexchange.model.ImportAssetFromApiGatewayApiResponseDetails.ReadOnly =
    new Wrapper(impl)
}
