package zio.aws.dataexchange.model
import zio.aws.dataexchange.model.primitives.{
  __string,
  Timestamp,
  Arn,
  Description,
  Name,
  Id
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class GetDataSetResponse(
    arn: Option[Arn] = None,
    assetType: Option[zio.aws.dataexchange.model.AssetType] = None,
    createdAt: Option[Timestamp] = None,
    description: Option[Description] = None,
    id: Option[Id] = None,
    name: Option[Name] = None,
    origin: Option[zio.aws.dataexchange.model.Origin] = None,
    originDetails: Option[zio.aws.dataexchange.model.OriginDetails] = None,
    sourceId: Option[Id] = None,
    tags: Option[Map[__string, __string]] = None,
    updatedAt: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dataexchange.model.GetDataSetResponse = {
    import GetDataSetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dataexchange.model.GetDataSetResponse
      .builder()
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(assetType.map(value => value.unwrap))(_.assetType)
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(id.map(value => Id.unwrap(value): java.lang.String))(_.id)
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(origin.map(value => value.unwrap))(_.origin)
      .optionallyWith(originDetails.map(value => value.buildAwsValue()))(
        _.originDetails
      )
      .optionallyWith(
        sourceId.map(value => Id.unwrap(value): java.lang.String)
      )(_.sourceId)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (__string.unwrap(key): java.lang.String) -> (__string
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(updatedAt.map(value => Timestamp.unwrap(value): Instant))(
        _.updatedAt
      )
      .build()
  }
  def asReadOnly: zio.aws.dataexchange.model.GetDataSetResponse.ReadOnly =
    zio.aws.dataexchange.model.GetDataSetResponse.wrap(buildAwsValue())
}
object GetDataSetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dataexchange.model.GetDataSetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dataexchange.model.GetDataSetResponse =
      zio.aws.dataexchange.model.GetDataSetResponse(
        arn.map(value => value),
        assetType.map(value => value),
        createdAt.map(value => value),
        description.map(value => value),
        id.map(value => value),
        name.map(value => value),
        origin.map(value => value),
        originDetails.map(value => value.asEditable),
        sourceId.map(value => value),
        tags.map(value => value),
        updatedAt.map(value => value)
      )
    def arn: Option[Arn]
    def assetType: Option[zio.aws.dataexchange.model.AssetType]
    def createdAt: Option[Timestamp]
    def description: Option[Description]
    def id: Option[Id]
    def name: Option[Name]
    def origin: Option[zio.aws.dataexchange.model.Origin]
    def originDetails: Option[zio.aws.dataexchange.model.OriginDetails.ReadOnly]
    def sourceId: Option[Id]
    def tags: Option[Map[__string, __string]]
    def updatedAt: Option[Timestamp]
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
    def getAssetType: ZIO[Any, AwsError, zio.aws.dataexchange.model.AssetType] =
      AwsError.unwrapOptionField("assetType", assetType)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getId: ZIO[Any, AwsError, Id] = AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getOrigin: ZIO[Any, AwsError, zio.aws.dataexchange.model.Origin] =
      AwsError.unwrapOptionField("origin", origin)
    def getOriginDetails: ZIO[
      Any,
      AwsError,
      zio.aws.dataexchange.model.OriginDetails.ReadOnly
    ] = AwsError.unwrapOptionField("originDetails", originDetails)
    def getSourceId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("sourceId", sourceId)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
    def getUpdatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dataexchange.model.GetDataSetResponse
  ) extends zio.aws.dataexchange.model.GetDataSetResponse.ReadOnly {
    override val arn: Option[Arn] = scala
      .Option(impl.arn())
      .map(value => zio.aws.dataexchange.model.primitives.Arn(value))
    override val assetType: Option[zio.aws.dataexchange.model.AssetType] = scala
      .Option(impl.assetType())
      .map(value => zio.aws.dataexchange.model.AssetType.wrap(value))
    override val createdAt: Option[Timestamp] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.dataexchange.model.primitives.Timestamp(value))
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.dataexchange.model.primitives.Description(value))
    override val id: Option[Id] = scala
      .Option(impl.id())
      .map(value => zio.aws.dataexchange.model.primitives.Id(value))
    override val name: Option[Name] = scala
      .Option(impl.name())
      .map(value => zio.aws.dataexchange.model.primitives.Name(value))
    override val origin: Option[zio.aws.dataexchange.model.Origin] = scala
      .Option(impl.origin())
      .map(value => zio.aws.dataexchange.model.Origin.wrap(value))
    override val originDetails
        : Option[zio.aws.dataexchange.model.OriginDetails.ReadOnly] = scala
      .Option(impl.originDetails())
      .map(value => zio.aws.dataexchange.model.OriginDetails.wrap(value))
    override val sourceId: Option[Id] = scala
      .Option(impl.sourceId())
      .map(value => zio.aws.dataexchange.model.primitives.Id(value))
    override val tags: Option[Map[__string, __string]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.dataexchange.model.primitives.__string(
              key
            ) -> zio.aws.dataexchange.model.primitives.__string(value)
          })
          .toMap
      )
    override val updatedAt: Option[Timestamp] = scala
      .Option(impl.updatedAt())
      .map(value => zio.aws.dataexchange.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dataexchange.model.GetDataSetResponse
  ): zio.aws.dataexchange.model.GetDataSetResponse.ReadOnly = new Wrapper(impl)
}
