package zio.aws.dataexchange.model
import zio.aws.dataexchange.model.primitives.__string
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteRevisionRequest(
    dataSetId: __string,
    revisionId: __string
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dataexchange.model.DeleteRevisionRequest = {
    import DeleteRevisionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dataexchange.model.DeleteRevisionRequest
      .builder()
      .dataSetId(__string.unwrap(dataSetId): java.lang.String)
      .revisionId(__string.unwrap(revisionId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.dataexchange.model.DeleteRevisionRequest.ReadOnly =
    zio.aws.dataexchange.model.DeleteRevisionRequest.wrap(buildAwsValue())
}
object DeleteRevisionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dataexchange.model.DeleteRevisionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dataexchange.model.DeleteRevisionRequest =
      zio.aws.dataexchange.model.DeleteRevisionRequest(dataSetId, revisionId)
    def dataSetId: __string
    def revisionId: __string
    def getDataSetId: ZIO[Any, Nothing, __string] = ZIO.succeed(dataSetId)
    def getRevisionId: ZIO[Any, Nothing, __string] = ZIO.succeed(revisionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dataexchange.model.DeleteRevisionRequest
  ) extends zio.aws.dataexchange.model.DeleteRevisionRequest.ReadOnly {
    override val dataSetId: __string =
      zio.aws.dataexchange.model.primitives.__string(impl.dataSetId())
    override val revisionId: __string =
      zio.aws.dataexchange.model.primitives.__string(impl.revisionId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.dataexchange.model.DeleteRevisionRequest
  ): zio.aws.dataexchange.model.DeleteRevisionRequest.ReadOnly = new Wrapper(
    impl
  )
}
