package zio.aws.dataexchange.model
import zio.aws.dataexchange.model.primitives.{__string, Name, Description}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateDataSetRequest(
    assetType: zio.aws.dataexchange.model.AssetType,
    description: Description,
    name: Name,
    tags: Option[Map[__string, __string]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dataexchange.model.CreateDataSetRequest = {
    import CreateDataSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dataexchange.model.CreateDataSetRequest
      .builder()
      .assetType(assetType.unwrap)
      .description(Description.unwrap(description): java.lang.String)
      .name(Name.unwrap(name): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (__string.unwrap(key): java.lang.String) -> (__string
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.dataexchange.model.CreateDataSetRequest.ReadOnly =
    zio.aws.dataexchange.model.CreateDataSetRequest.wrap(buildAwsValue())
}
object CreateDataSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dataexchange.model.CreateDataSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dataexchange.model.CreateDataSetRequest =
      zio.aws.dataexchange.model.CreateDataSetRequest(
        assetType,
        description,
        name,
        tags.map(value => value)
      )
    def assetType: zio.aws.dataexchange.model.AssetType
    def description: Description
    def name: Name
    def tags: Option[Map[__string, __string]]
    def getAssetType: ZIO[Any, Nothing, zio.aws.dataexchange.model.AssetType] =
      ZIO.succeed(assetType)
    def getDescription: ZIO[Any, Nothing, Description] =
      ZIO.succeed(description)
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dataexchange.model.CreateDataSetRequest
  ) extends zio.aws.dataexchange.model.CreateDataSetRequest.ReadOnly {
    override val assetType: zio.aws.dataexchange.model.AssetType =
      zio.aws.dataexchange.model.AssetType.wrap(impl.assetType())
    override val description: Description =
      zio.aws.dataexchange.model.primitives.Description(impl.description())
    override val name: Name =
      zio.aws.dataexchange.model.primitives.Name(impl.name())
    override val tags: Option[Map[__string, __string]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.dataexchange.model.primitives.__string(
              key
            ) -> zio.aws.dataexchange.model.primitives.__string(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dataexchange.model.CreateDataSetRequest
  ): zio.aws.dataexchange.model.CreateDataSetRequest.ReadOnly = new Wrapper(
    impl
  )
}
