package zio.aws.dataexchange
import zio.aws.dataexchange.model.AssetEntry.ReadOnly
import software.amazon.awssdk.services.dataexchange.DataExchangeAsyncClient
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.aws.dataexchange.model.{
  DeleteAssetRequest,
  DeleteDataSetRequest,
  GetEventActionRequest,
  ListDataSetsRequest,
  CancelJobRequest,
  CreateDataSetRequest,
  ListJobsRequest,
  GetDataSetRequest,
  GetJobRequest,
  ListTagsForResourceRequest,
  GetRevisionRequest,
  CreateEventActionRequest,
  CreateRevisionRequest,
  UpdateDataSetRequest,
  DeleteEventActionRequest,
  UpdateAssetRequest,
  UntagResourceRequest,
  CreateJobRequest,
  GetAssetRequest,
  ListDataSetRevisionsRequest,
  DeleteRevisionRequest,
  UpdateRevisionRequest,
  StartJobRequest,
  UpdateEventActionRequest,
  ListEventActionsRequest,
  TagResourceRequest,
  ListRevisionAssetsRequest
}
import zio.{IO, ZEnvironment, URLayer}
import zio.stream.ZStream
import zio.test.mock.{Proxy, Mock}
object DataExchangeMock extends Mock[DataExchange] {
  object StartJob
      extends Effect[
        StartJobRequest,
        AwsError,
        zio.aws.dataexchange.model.StartJobResponse.ReadOnly
      ]
  object ListDataSetRevisions
      extends Stream[
        ListDataSetRevisionsRequest,
        AwsError,
        zio.aws.dataexchange.model.RevisionEntry.ReadOnly
      ]
  object ListDataSetRevisionsPaginated
      extends Effect[
        ListDataSetRevisionsRequest,
        AwsError,
        zio.aws.dataexchange.model.ListDataSetRevisionsResponse.ReadOnly
      ]
  object DeleteDataSet extends Effect[DeleteDataSetRequest, AwsError, Unit]
  object CreateJob
      extends Effect[
        CreateJobRequest,
        AwsError,
        zio.aws.dataexchange.model.CreateJobResponse.ReadOnly
      ]
  object CancelJob extends Effect[CancelJobRequest, AwsError, Unit]
  object ListDataSets
      extends Stream[
        ListDataSetsRequest,
        AwsError,
        zio.aws.dataexchange.model.DataSetEntry.ReadOnly
      ]
  object ListDataSetsPaginated
      extends Effect[
        ListDataSetsRequest,
        AwsError,
        zio.aws.dataexchange.model.ListDataSetsResponse.ReadOnly
      ]
  object CreateEventAction
      extends Effect[
        CreateEventActionRequest,
        AwsError,
        zio.aws.dataexchange.model.CreateEventActionResponse.ReadOnly
      ]
  object UpdateEventAction
      extends Effect[
        UpdateEventActionRequest,
        AwsError,
        zio.aws.dataexchange.model.UpdateEventActionResponse.ReadOnly
      ]
  object ListEventActions
      extends Stream[
        ListEventActionsRequest,
        AwsError,
        zio.aws.dataexchange.model.EventActionEntry.ReadOnly
      ]
  object ListEventActionsPaginated
      extends Effect[
        ListEventActionsRequest,
        AwsError,
        zio.aws.dataexchange.model.ListEventActionsResponse.ReadOnly
      ]
  object DeleteEventAction
      extends Effect[DeleteEventActionRequest, AwsError, Unit]
  object GetEventAction
      extends Effect[
        GetEventActionRequest,
        AwsError,
        zio.aws.dataexchange.model.GetEventActionResponse.ReadOnly
      ]
  object UpdateRevision
      extends Effect[
        UpdateRevisionRequest,
        AwsError,
        zio.aws.dataexchange.model.UpdateRevisionResponse.ReadOnly
      ]
  object CreateDataSet
      extends Effect[
        CreateDataSetRequest,
        AwsError,
        zio.aws.dataexchange.model.CreateDataSetResponse.ReadOnly
      ]
  object UntagResource extends Effect[UntagResourceRequest, AwsError, Unit]
  object DeleteRevision extends Effect[DeleteRevisionRequest, AwsError, Unit]
  object GetJob
      extends Effect[
        GetJobRequest,
        AwsError,
        zio.aws.dataexchange.model.GetJobResponse.ReadOnly
      ]
  object GetAsset
      extends Effect[
        GetAssetRequest,
        AwsError,
        zio.aws.dataexchange.model.GetAssetResponse.ReadOnly
      ]
  object GetRevision
      extends Effect[
        GetRevisionRequest,
        AwsError,
        zio.aws.dataexchange.model.GetRevisionResponse.ReadOnly
      ]
  object DeleteAsset extends Effect[DeleteAssetRequest, AwsError, Unit]
  object UpdateDataSet
      extends Effect[
        UpdateDataSetRequest,
        AwsError,
        zio.aws.dataexchange.model.UpdateDataSetResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.dataexchange.model.ListTagsForResourceResponse.ReadOnly
      ]
  object ListJobs
      extends Stream[
        ListJobsRequest,
        AwsError,
        zio.aws.dataexchange.model.JobEntry.ReadOnly
      ]
  object ListJobsPaginated
      extends Effect[
        ListJobsRequest,
        AwsError,
        zio.aws.dataexchange.model.ListJobsResponse.ReadOnly
      ]
  object TagResource extends Effect[TagResourceRequest, AwsError, Unit]
  object ListRevisionAssets
      extends Stream[ListRevisionAssetsRequest, AwsError, ReadOnly]
  object ListRevisionAssetsPaginated
      extends Effect[
        ListRevisionAssetsRequest,
        AwsError,
        zio.aws.dataexchange.model.ListRevisionAssetsResponse.ReadOnly
      ]
  object CreateRevision
      extends Effect[
        CreateRevisionRequest,
        AwsError,
        zio.aws.dataexchange.model.CreateRevisionResponse.ReadOnly
      ]
  object UpdateAsset
      extends Effect[
        UpdateAssetRequest,
        AwsError,
        zio.aws.dataexchange.model.UpdateAssetResponse.ReadOnly
      ]
  object GetDataSet
      extends Effect[
        GetDataSetRequest,
        AwsError,
        zio.aws.dataexchange.model.GetDataSetResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, DataExchange] = zio.ZIO
    .service[Proxy]
    .flatMap { proxy =>
      withRuntime[Proxy].map { rts =>
        new DataExchange {
          val api: DataExchangeAsyncClient = null
          def withAspect[R1](newAspect: AwsCallAspect[R1], r: ZEnvironment[R1])
              : DataExchange = this
          def startJob(request: StartJobRequest): IO[
            AwsError,
            zio.aws.dataexchange.model.StartJobResponse.ReadOnly
          ] = proxy(StartJob, request)
          def listDataSetRevisions(
              request: ListDataSetRevisionsRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.dataexchange.model.RevisionEntry.ReadOnly
          ] = rts.unsafeRun(proxy(ListDataSetRevisions, request))
          def listDataSetRevisionsPaginated(
              request: ListDataSetRevisionsRequest
          ): IO[
            AwsError,
            zio.aws.dataexchange.model.ListDataSetRevisionsResponse.ReadOnly
          ] = proxy(ListDataSetRevisionsPaginated, request)
          def deleteDataSet(request: DeleteDataSetRequest): IO[AwsError, Unit] =
            proxy(DeleteDataSet, request)
          def createJob(request: CreateJobRequest): IO[
            AwsError,
            zio.aws.dataexchange.model.CreateJobResponse.ReadOnly
          ] = proxy(CreateJob, request)
          def cancelJob(request: CancelJobRequest): IO[AwsError, Unit] =
            proxy(CancelJob, request)
          def listDataSets(request: ListDataSetsRequest): ZStream[
            Any,
            AwsError,
            zio.aws.dataexchange.model.DataSetEntry.ReadOnly
          ] = rts.unsafeRun(proxy(ListDataSets, request))
          def listDataSetsPaginated(request: ListDataSetsRequest): IO[
            AwsError,
            zio.aws.dataexchange.model.ListDataSetsResponse.ReadOnly
          ] = proxy(ListDataSetsPaginated, request)
          def createEventAction(request: CreateEventActionRequest): IO[
            AwsError,
            zio.aws.dataexchange.model.CreateEventActionResponse.ReadOnly
          ] = proxy(CreateEventAction, request)
          def updateEventAction(request: UpdateEventActionRequest): IO[
            AwsError,
            zio.aws.dataexchange.model.UpdateEventActionResponse.ReadOnly
          ] = proxy(UpdateEventAction, request)
          def listEventActions(request: ListEventActionsRequest): ZStream[
            Any,
            AwsError,
            zio.aws.dataexchange.model.EventActionEntry.ReadOnly
          ] = rts.unsafeRun(proxy(ListEventActions, request))
          def listEventActionsPaginated(request: ListEventActionsRequest): IO[
            AwsError,
            zio.aws.dataexchange.model.ListEventActionsResponse.ReadOnly
          ] = proxy(ListEventActionsPaginated, request)
          def deleteEventAction(
              request: DeleteEventActionRequest
          ): IO[AwsError, Unit] = proxy(DeleteEventAction, request)
          def getEventAction(request: GetEventActionRequest): IO[
            AwsError,
            zio.aws.dataexchange.model.GetEventActionResponse.ReadOnly
          ] = proxy(GetEventAction, request)
          def updateRevision(request: UpdateRevisionRequest): IO[
            AwsError,
            zio.aws.dataexchange.model.UpdateRevisionResponse.ReadOnly
          ] = proxy(UpdateRevision, request)
          def createDataSet(request: CreateDataSetRequest): IO[
            AwsError,
            zio.aws.dataexchange.model.CreateDataSetResponse.ReadOnly
          ] = proxy(CreateDataSet, request)
          def untagResource(request: UntagResourceRequest): IO[AwsError, Unit] =
            proxy(UntagResource, request)
          def deleteRevision(
              request: DeleteRevisionRequest
          ): IO[AwsError, Unit] = proxy(DeleteRevision, request)
          def getJob(
              request: GetJobRequest
          ): IO[AwsError, zio.aws.dataexchange.model.GetJobResponse.ReadOnly] =
            proxy(GetJob, request)
          def getAsset(request: GetAssetRequest): IO[
            AwsError,
            zio.aws.dataexchange.model.GetAssetResponse.ReadOnly
          ] = proxy(GetAsset, request)
          def getRevision(request: GetRevisionRequest): IO[
            AwsError,
            zio.aws.dataexchange.model.GetRevisionResponse.ReadOnly
          ] = proxy(GetRevision, request)
          def deleteAsset(request: DeleteAssetRequest): IO[AwsError, Unit] =
            proxy(DeleteAsset, request)
          def updateDataSet(request: UpdateDataSetRequest): IO[
            AwsError,
            zio.aws.dataexchange.model.UpdateDataSetResponse.ReadOnly
          ] = proxy(UpdateDataSet, request)
          def listTagsForResource(request: ListTagsForResourceRequest): IO[
            AwsError,
            zio.aws.dataexchange.model.ListTagsForResourceResponse.ReadOnly
          ] = proxy(ListTagsForResource, request)
          def listJobs(request: ListJobsRequest): ZStream[
            Any,
            AwsError,
            zio.aws.dataexchange.model.JobEntry.ReadOnly
          ] = rts.unsafeRun(proxy(ListJobs, request))
          def listJobsPaginated(request: ListJobsRequest): IO[
            AwsError,
            zio.aws.dataexchange.model.ListJobsResponse.ReadOnly
          ] = proxy(ListJobsPaginated, request)
          def tagResource(request: TagResourceRequest): IO[AwsError, Unit] =
            proxy(TagResource, request)
          def listRevisionAssets(
              request: ListRevisionAssetsRequest
          ): ZStream[Any, AwsError, ReadOnly] =
            rts.unsafeRun(proxy(ListRevisionAssets, request))
          def listRevisionAssetsPaginated(
              request: ListRevisionAssetsRequest
          ): IO[
            AwsError,
            zio.aws.dataexchange.model.ListRevisionAssetsResponse.ReadOnly
          ] = proxy(ListRevisionAssetsPaginated, request)
          def createRevision(request: CreateRevisionRequest): IO[
            AwsError,
            zio.aws.dataexchange.model.CreateRevisionResponse.ReadOnly
          ] = proxy(CreateRevision, request)
          def updateAsset(request: UpdateAssetRequest): IO[
            AwsError,
            zio.aws.dataexchange.model.UpdateAssetResponse.ReadOnly
          ] = proxy(UpdateAsset, request)
          def getDataSet(request: GetDataSetRequest): IO[
            AwsError,
            zio.aws.dataexchange.model.GetDataSetResponse.ReadOnly
          ] = proxy(GetDataSet, request)
        }
      }
    }
    .toLayer
}
