package zio.aws.databrew.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.databrew.model.primitives.NextToken
import scala.jdk.CollectionConverters.*
final case class ListDatasetsResponse(
    datasets: Iterable[zio.aws.databrew.model.Dataset],
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.ListDatasetsResponse = {
    import ListDatasetsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.ListDatasetsResponse
      .builder()
      .datasets(datasets.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.ListDatasetsResponse.ReadOnly =
    zio.aws.databrew.model.ListDatasetsResponse.wrap(buildAwsValue())
}
object ListDatasetsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.ListDatasetsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.ListDatasetsResponse =
      zio.aws.databrew.model.ListDatasetsResponse(
        datasets.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def datasets: List[zio.aws.databrew.model.Dataset.ReadOnly]
    def nextToken: Optional[NextToken]
    def getDatasets
        : ZIO[Any, Nothing, List[zio.aws.databrew.model.Dataset.ReadOnly]] =
      ZIO.succeed(datasets)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.ListDatasetsResponse
  ) extends zio.aws.databrew.model.ListDatasetsResponse.ReadOnly {
    override val datasets: List[zio.aws.databrew.model.Dataset.ReadOnly] = impl
      .datasets()
      .asScala
      .map { item =>
        zio.aws.databrew.model.Dataset.wrap(item)
      }
      .toList
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.databrew.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.ListDatasetsResponse
  ): zio.aws.databrew.model.ListDatasetsResponse.ReadOnly = new Wrapper(impl)
}
