package zio.aws.databrew.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class S3TableOutputOptions(
    location: zio.aws.databrew.model.S3Location
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.S3TableOutputOptions = {
    import S3TableOutputOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.S3TableOutputOptions
      .builder()
      .location(location.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.S3TableOutputOptions.ReadOnly =
    zio.aws.databrew.model.S3TableOutputOptions.wrap(buildAwsValue())
}
object S3TableOutputOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.S3TableOutputOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.S3TableOutputOptions =
      zio.aws.databrew.model.S3TableOutputOptions(location.asEditable)
    def location: zio.aws.databrew.model.S3Location.ReadOnly
    def getLocation
        : ZIO[Any, Nothing, zio.aws.databrew.model.S3Location.ReadOnly] =
      ZIO.succeed(location)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.S3TableOutputOptions
  ) extends zio.aws.databrew.model.S3TableOutputOptions.ReadOnly {
    override val location: zio.aws.databrew.model.S3Location.ReadOnly =
      zio.aws.databrew.model.S3Location.wrap(impl.location())
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.S3TableOutputOptions
  ): zio.aws.databrew.model.S3TableOutputOptions.ReadOnly = new Wrapper(impl)
}
