package zio.aws.databrew.model
import zio.aws.databrew.model.primitives.{
  Timeout,
  ProjectName,
  Date,
  AccountId,
  LastModifiedBy,
  TagValue,
  Arn,
  DatasetName,
  JobName,
  CreatedBy,
  EncryptionKeyArn,
  MaxCapacity,
  MaxRetries,
  TagKey
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class Job(
    accountId: Optional[AccountId] = Optional.Absent,
    createdBy: Optional[CreatedBy] = Optional.Absent,
    createDate: Optional[Date] = Optional.Absent,
    datasetName: Optional[DatasetName] = Optional.Absent,
    encryptionKeyArn: Optional[EncryptionKeyArn] = Optional.Absent,
    encryptionMode: Optional[zio.aws.databrew.model.EncryptionMode] =
      Optional.Absent,
    name: JobName,
    `type`: Optional[zio.aws.databrew.model.JobType] = Optional.Absent,
    lastModifiedBy: Optional[LastModifiedBy] = Optional.Absent,
    lastModifiedDate: Optional[Date] = Optional.Absent,
    logSubscription: Optional[zio.aws.databrew.model.LogSubscription] =
      Optional.Absent,
    maxCapacity: Optional[MaxCapacity] = Optional.Absent,
    maxRetries: Optional[MaxRetries] = Optional.Absent,
    outputs: Optional[Iterable[zio.aws.databrew.model.Output]] =
      Optional.Absent,
    dataCatalogOutputs: Optional[
      Iterable[zio.aws.databrew.model.DataCatalogOutput]
    ] = Optional.Absent,
    databaseOutputs: Optional[Iterable[zio.aws.databrew.model.DatabaseOutput]] =
      Optional.Absent,
    projectName: Optional[ProjectName] = Optional.Absent,
    recipeReference: Optional[zio.aws.databrew.model.RecipeReference] =
      Optional.Absent,
    resourceArn: Optional[Arn] = Optional.Absent,
    roleArn: Optional[Arn] = Optional.Absent,
    timeout: Optional[Timeout] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    jobSample: Optional[zio.aws.databrew.model.JobSample] = Optional.Absent,
    validationConfigurations: Optional[
      Iterable[zio.aws.databrew.model.ValidationConfiguration]
    ] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.databrew.model.Job = {
    import Job.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.Job
      .builder()
      .optionallyWith(
        accountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .optionallyWith(
        createdBy.map(value => CreatedBy.unwrap(value): java.lang.String)
      )(_.createdBy)
      .optionallyWith(createDate.map(value => Date.unwrap(value): Instant))(
        _.createDate
      )
      .optionallyWith(
        datasetName.map(value => DatasetName.unwrap(value): java.lang.String)
      )(_.datasetName)
      .optionallyWith(
        encryptionKeyArn.map(value =>
          EncryptionKeyArn.unwrap(value): java.lang.String
        )
      )(_.encryptionKeyArn)
      .optionallyWith(encryptionMode.map(value => value.unwrap))(
        _.encryptionMode
      )
      .name(JobName.unwrap(name): java.lang.String)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        lastModifiedBy.map(value =>
          LastModifiedBy.unwrap(value): java.lang.String
        )
      )(_.lastModifiedBy)
      .optionallyWith(
        lastModifiedDate.map(value => Date.unwrap(value): Instant)
      )(_.lastModifiedDate)
      .optionallyWith(logSubscription.map(value => value.unwrap))(
        _.logSubscription
      )
      .optionallyWith(
        maxCapacity.map(value => MaxCapacity.unwrap(value): Integer)
      )(_.maxCapacity)
      .optionallyWith(
        maxRetries.map(value => MaxRetries.unwrap(value): Integer)
      )(_.maxRetries)
      .optionallyWith(
        outputs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.outputs)
      .optionallyWith(
        dataCatalogOutputs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dataCatalogOutputs)
      .optionallyWith(
        databaseOutputs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.databaseOutputs)
      .optionallyWith(
        projectName.map(value => ProjectName.unwrap(value): java.lang.String)
      )(_.projectName)
      .optionallyWith(recipeReference.map(value => value.buildAwsValue()))(
        _.recipeReference
      )
      .optionallyWith(
        resourceArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.resourceArn)
      .optionallyWith(
        roleArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(timeout.map(value => Timeout.unwrap(value): Integer))(
        _.timeout
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(jobSample.map(value => value.buildAwsValue()))(
        _.jobSample
      )
      .optionallyWith(
        validationConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.validationConfigurations)
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.Job.ReadOnly =
    zio.aws.databrew.model.Job.wrap(buildAwsValue())
}
object Job {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.databrew.model.Job] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.Job = zio.aws.databrew.model.Job(
      accountId.map(value => value),
      createdBy.map(value => value),
      createDate.map(value => value),
      datasetName.map(value => value),
      encryptionKeyArn.map(value => value),
      encryptionMode.map(value => value),
      name,
      `type`.map(value => value),
      lastModifiedBy.map(value => value),
      lastModifiedDate.map(value => value),
      logSubscription.map(value => value),
      maxCapacity.map(value => value),
      maxRetries.map(value => value),
      outputs.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      dataCatalogOutputs.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      databaseOutputs.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      projectName.map(value => value),
      recipeReference.map(value => value.asEditable),
      resourceArn.map(value => value),
      roleArn.map(value => value),
      timeout.map(value => value),
      tags.map(value => value),
      jobSample.map(value => value.asEditable),
      validationConfigurations.map(value =>
        value.map { item =>
          item.asEditable
        }
      )
    )
    def accountId: Optional[AccountId]
    def createdBy: Optional[CreatedBy]
    def createDate: Optional[Date]
    def datasetName: Optional[DatasetName]
    def encryptionKeyArn: Optional[EncryptionKeyArn]
    def encryptionMode: Optional[zio.aws.databrew.model.EncryptionMode]
    def name: JobName
    def `type`: Optional[zio.aws.databrew.model.JobType]
    def lastModifiedBy: Optional[LastModifiedBy]
    def lastModifiedDate: Optional[Date]
    def logSubscription: Optional[zio.aws.databrew.model.LogSubscription]
    def maxCapacity: Optional[MaxCapacity]
    def maxRetries: Optional[MaxRetries]
    def outputs: Optional[List[zio.aws.databrew.model.Output.ReadOnly]]
    def dataCatalogOutputs
        : Optional[List[zio.aws.databrew.model.DataCatalogOutput.ReadOnly]]
    def databaseOutputs
        : Optional[List[zio.aws.databrew.model.DatabaseOutput.ReadOnly]]
    def projectName: Optional[ProjectName]
    def recipeReference
        : Optional[zio.aws.databrew.model.RecipeReference.ReadOnly]
    def resourceArn: Optional[Arn]
    def roleArn: Optional[Arn]
    def timeout: Optional[Timeout]
    def tags: Optional[Map[TagKey, TagValue]]
    def jobSample: Optional[zio.aws.databrew.model.JobSample.ReadOnly]
    def validationConfigurations: Optional[
      List[zio.aws.databrew.model.ValidationConfiguration.ReadOnly]
    ]
    def getAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getCreatedBy: ZIO[Any, AwsError, CreatedBy] =
      AwsError.unwrapOptionField("createdBy", createdBy)
    def getCreateDate: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("createDate", createDate)
    def getDatasetName: ZIO[Any, AwsError, DatasetName] =
      AwsError.unwrapOptionField("datasetName", datasetName)
    def getEncryptionKeyArn: ZIO[Any, AwsError, EncryptionKeyArn] =
      AwsError.unwrapOptionField("encryptionKeyArn", encryptionKeyArn)
    def getEncryptionMode
        : ZIO[Any, AwsError, zio.aws.databrew.model.EncryptionMode] =
      AwsError.unwrapOptionField("encryptionMode", encryptionMode)
    def getName: ZIO[Any, Nothing, JobName] = ZIO.succeed(name)
    def getType: ZIO[Any, AwsError, zio.aws.databrew.model.JobType] =
      AwsError.unwrapOptionField("type", `type`)
    def getLastModifiedBy: ZIO[Any, AwsError, LastModifiedBy] =
      AwsError.unwrapOptionField("lastModifiedBy", lastModifiedBy)
    def getLastModifiedDate: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("lastModifiedDate", lastModifiedDate)
    def getLogSubscription
        : ZIO[Any, AwsError, zio.aws.databrew.model.LogSubscription] =
      AwsError.unwrapOptionField("logSubscription", logSubscription)
    def getMaxCapacity: ZIO[Any, AwsError, MaxCapacity] =
      AwsError.unwrapOptionField("maxCapacity", maxCapacity)
    def getMaxRetries: ZIO[Any, AwsError, MaxRetries] =
      AwsError.unwrapOptionField("maxRetries", maxRetries)
    def getOutputs
        : ZIO[Any, AwsError, List[zio.aws.databrew.model.Output.ReadOnly]] =
      AwsError.unwrapOptionField("outputs", outputs)
    def getDataCatalogOutputs: ZIO[Any, AwsError, List[
      zio.aws.databrew.model.DataCatalogOutput.ReadOnly
    ]] = AwsError.unwrapOptionField("dataCatalogOutputs", dataCatalogOutputs)
    def getDatabaseOutputs: ZIO[Any, AwsError, List[
      zio.aws.databrew.model.DatabaseOutput.ReadOnly
    ]] = AwsError.unwrapOptionField("databaseOutputs", databaseOutputs)
    def getProjectName: ZIO[Any, AwsError, ProjectName] =
      AwsError.unwrapOptionField("projectName", projectName)
    def getRecipeReference
        : ZIO[Any, AwsError, zio.aws.databrew.model.RecipeReference.ReadOnly] =
      AwsError.unwrapOptionField("recipeReference", recipeReference)
    def getResourceArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("resourceArn", resourceArn)
    def getRoleArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getTimeout: ZIO[Any, AwsError, Timeout] =
      AwsError.unwrapOptionField("timeout", timeout)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getJobSample
        : ZIO[Any, AwsError, zio.aws.databrew.model.JobSample.ReadOnly] =
      AwsError.unwrapOptionField("jobSample", jobSample)
    def getValidationConfigurations: ZIO[Any, AwsError, List[
      zio.aws.databrew.model.ValidationConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "validationConfigurations",
      validationConfigurations
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.Job
  ) extends zio.aws.databrew.model.Job.ReadOnly {
    override val accountId: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value => zio.aws.databrew.model.primitives.AccountId(value))
    override val createdBy: Optional[CreatedBy] = zio.aws.core.internal
      .optionalFromNullable(impl.createdBy())
      .map(value => zio.aws.databrew.model.primitives.CreatedBy(value))
    override val createDate: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.createDate())
      .map(value => zio.aws.databrew.model.primitives.Date(value))
    override val datasetName: Optional[DatasetName] = zio.aws.core.internal
      .optionalFromNullable(impl.datasetName())
      .map(value => zio.aws.databrew.model.primitives.DatasetName(value))
    override val encryptionKeyArn: Optional[EncryptionKeyArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.encryptionKeyArn())
        .map(value => zio.aws.databrew.model.primitives.EncryptionKeyArn(value))
    override val encryptionMode
        : Optional[zio.aws.databrew.model.EncryptionMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.encryptionMode())
        .map(value => zio.aws.databrew.model.EncryptionMode.wrap(value))
    override val name: JobName =
      zio.aws.databrew.model.primitives.JobName(impl.name())
    override val `type`: Optional[zio.aws.databrew.model.JobType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.databrew.model.JobType.wrap(value))
    override val lastModifiedBy: Optional[LastModifiedBy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastModifiedBy())
        .map(value => zio.aws.databrew.model.primitives.LastModifiedBy(value))
    override val lastModifiedDate: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedDate())
      .map(value => zio.aws.databrew.model.primitives.Date(value))
    override val logSubscription
        : Optional[zio.aws.databrew.model.LogSubscription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.logSubscription())
        .map(value => zio.aws.databrew.model.LogSubscription.wrap(value))
    override val maxCapacity: Optional[MaxCapacity] = zio.aws.core.internal
      .optionalFromNullable(impl.maxCapacity())
      .map(value => zio.aws.databrew.model.primitives.MaxCapacity(value))
    override val maxRetries: Optional[MaxRetries] = zio.aws.core.internal
      .optionalFromNullable(impl.maxRetries())
      .map(value => zio.aws.databrew.model.primitives.MaxRetries(value))
    override val outputs
        : Optional[List[zio.aws.databrew.model.Output.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.outputs())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.databrew.model.Output.wrap(item)
          }.toList
        )
    override val dataCatalogOutputs
        : Optional[List[zio.aws.databrew.model.DataCatalogOutput.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataCatalogOutputs())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.databrew.model.DataCatalogOutput.wrap(item)
          }.toList
        )
    override val databaseOutputs
        : Optional[List[zio.aws.databrew.model.DatabaseOutput.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.databaseOutputs())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.databrew.model.DatabaseOutput.wrap(item)
          }.toList
        )
    override val projectName: Optional[ProjectName] = zio.aws.core.internal
      .optionalFromNullable(impl.projectName())
      .map(value => zio.aws.databrew.model.primitives.ProjectName(value))
    override val recipeReference
        : Optional[zio.aws.databrew.model.RecipeReference.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.recipeReference())
        .map(value => zio.aws.databrew.model.RecipeReference.wrap(value))
    override val resourceArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceArn())
      .map(value => zio.aws.databrew.model.primitives.Arn(value))
    override val roleArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => zio.aws.databrew.model.primitives.Arn(value))
    override val timeout: Optional[Timeout] = zio.aws.core.internal
      .optionalFromNullable(impl.timeout())
      .map(value => zio.aws.databrew.model.primitives.Timeout(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.databrew.model.primitives
              .TagKey(key) -> zio.aws.databrew.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val jobSample
        : Optional[zio.aws.databrew.model.JobSample.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jobSample())
        .map(value => zio.aws.databrew.model.JobSample.wrap(value))
    override val validationConfigurations: Optional[
      List[zio.aws.databrew.model.ValidationConfiguration.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.validationConfigurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.databrew.model.ValidationConfiguration.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.Job
  ): zio.aws.databrew.model.Job.ReadOnly = new Wrapper(impl)
}
