package zio.aws.databrew.model
import zio.aws.databrew.model.primitives.{NextToken, MaxResults100, JobName}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListSchedulesRequest(
    jobName: Optional[JobName] = Optional.Absent,
    maxResults: Optional[MaxResults100] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.ListSchedulesRequest = {
    import ListSchedulesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.ListSchedulesRequest
      .builder()
      .optionallyWith(
        jobName.map(value => JobName.unwrap(value): java.lang.String)
      )(_.jobName)
      .optionallyWith(
        maxResults.map(value => MaxResults100.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.ListSchedulesRequest.ReadOnly =
    zio.aws.databrew.model.ListSchedulesRequest.wrap(buildAwsValue())
}
object ListSchedulesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.ListSchedulesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.ListSchedulesRequest =
      zio.aws.databrew.model.ListSchedulesRequest(
        jobName.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def jobName: Optional[JobName]
    def maxResults: Optional[MaxResults100]
    def nextToken: Optional[NextToken]
    def getJobName: ZIO[Any, AwsError, JobName] =
      AwsError.unwrapOptionField("jobName", jobName)
    def getMaxResults: ZIO[Any, AwsError, MaxResults100] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.ListSchedulesRequest
  ) extends zio.aws.databrew.model.ListSchedulesRequest.ReadOnly {
    override val jobName: Optional[JobName] = zio.aws.core.internal
      .optionalFromNullable(impl.jobName())
      .map(value => zio.aws.databrew.model.primitives.JobName(value))
    override val maxResults: Optional[MaxResults100] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.databrew.model.primitives.MaxResults100(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.databrew.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.ListSchedulesRequest
  ): zio.aws.databrew.model.ListSchedulesRequest.ReadOnly = new Wrapper(impl)
}
