package zio.aws.databrew.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.databrew.model.primitives.{JobRunId, JobName}
import scala.jdk.CollectionConverters.*
final case class DescribeJobRunRequest(name: JobName, runId: JobRunId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.DescribeJobRunRequest = {
    import DescribeJobRunRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.DescribeJobRunRequest
      .builder()
      .name(JobName.unwrap(name): java.lang.String)
      .runId(JobRunId.unwrap(runId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.DescribeJobRunRequest.ReadOnly =
    zio.aws.databrew.model.DescribeJobRunRequest.wrap(buildAwsValue())
}
object DescribeJobRunRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.DescribeJobRunRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.DescribeJobRunRequest =
      zio.aws.databrew.model.DescribeJobRunRequest(name, runId)
    def name: JobName
    def runId: JobRunId
    def getName: ZIO[Any, Nothing, JobName] = ZIO.succeed(name)
    def getRunId: ZIO[Any, Nothing, JobRunId] = ZIO.succeed(runId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.DescribeJobRunRequest
  ) extends zio.aws.databrew.model.DescribeJobRunRequest.ReadOnly {
    override val name: JobName =
      zio.aws.databrew.model.primitives.JobName(impl.name())
    override val runId: JobRunId =
      zio.aws.databrew.model.primitives.JobRunId(impl.runId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.DescribeJobRunRequest
  ): zio.aws.databrew.model.DescribeJobRunRequest.ReadOnly = new Wrapper(impl)
}
