package zio.aws.databrew.model
import scala.jdk.CollectionConverters.*
sealed trait JobType {
  def unwrap: software.amazon.awssdk.services.databrew.model.JobType
}
object JobType {
  def wrap(
      value: software.amazon.awssdk.services.databrew.model.JobType
  ): zio.aws.databrew.model.JobType = value match {
    case software.amazon.awssdk.services.databrew.model.JobType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.databrew.model.JobType.PROFILE =>
      val r = PROFILE
      r
    case software.amazon.awssdk.services.databrew.model.JobType.RECIPE =>
      val r = RECIPE
      r
  }
  case object unknownToSdkVersion extends zio.aws.databrew.model.JobType {
    override def unwrap
        : software.amazon.awssdk.services.databrew.model.JobType =
      software.amazon.awssdk.services.databrew.model.JobType.UNKNOWN_TO_SDK_VERSION
  }
  case object PROFILE extends zio.aws.databrew.model.JobType {
    override def unwrap
        : software.amazon.awssdk.services.databrew.model.JobType =
      software.amazon.awssdk.services.databrew.model.JobType.PROFILE
  }
  case object RECIPE extends zio.aws.databrew.model.JobType {
    override def unwrap
        : software.amazon.awssdk.services.databrew.model.JobType =
      software.amazon.awssdk.services.databrew.model.JobType.RECIPE
  }
}
