package zio.aws.databrew.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.databrew.model.primitives.GlueConnectionName
import scala.jdk.CollectionConverters.*
final case class DatabaseOutput(
    glueConnectionName: GlueConnectionName,
    databaseOptions: zio.aws.databrew.model.DatabaseTableOutputOptions,
    databaseOutputMode: Optional[zio.aws.databrew.model.DatabaseOutputMode] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.DatabaseOutput = {
    import DatabaseOutput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.DatabaseOutput
      .builder()
      .glueConnectionName(
        GlueConnectionName.unwrap(glueConnectionName): java.lang.String
      )
      .databaseOptions(databaseOptions.buildAwsValue())
      .optionallyWith(databaseOutputMode.map(value => value.unwrap))(
        _.databaseOutputMode
      )
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.DatabaseOutput.ReadOnly =
    zio.aws.databrew.model.DatabaseOutput.wrap(buildAwsValue())
}
object DatabaseOutput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.DatabaseOutput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.DatabaseOutput =
      zio.aws.databrew.model.DatabaseOutput(
        glueConnectionName,
        databaseOptions.asEditable,
        databaseOutputMode.map(value => value)
      )
    def glueConnectionName: GlueConnectionName
    def databaseOptions
        : zio.aws.databrew.model.DatabaseTableOutputOptions.ReadOnly
    def databaseOutputMode: Optional[zio.aws.databrew.model.DatabaseOutputMode]
    def getGlueConnectionName: ZIO[Any, Nothing, GlueConnectionName] =
      ZIO.succeed(glueConnectionName)
    def getDatabaseOptions: ZIO[
      Any,
      Nothing,
      zio.aws.databrew.model.DatabaseTableOutputOptions.ReadOnly
    ] = ZIO.succeed(databaseOptions)
    def getDatabaseOutputMode
        : ZIO[Any, AwsError, zio.aws.databrew.model.DatabaseOutputMode] =
      AwsError.unwrapOptionField("databaseOutputMode", databaseOutputMode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.DatabaseOutput
  ) extends zio.aws.databrew.model.DatabaseOutput.ReadOnly {
    override val glueConnectionName: GlueConnectionName =
      zio.aws.databrew.model.primitives
        .GlueConnectionName(impl.glueConnectionName())
    override val databaseOptions
        : zio.aws.databrew.model.DatabaseTableOutputOptions.ReadOnly =
      zio.aws.databrew.model.DatabaseTableOutputOptions
        .wrap(impl.databaseOptions())
    override val databaseOutputMode
        : Optional[zio.aws.databrew.model.DatabaseOutputMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.databaseOutputMode())
        .map(value => zio.aws.databrew.model.DatabaseOutputMode.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.DatabaseOutput
  ): zio.aws.databrew.model.DatabaseOutput.ReadOnly = new Wrapper(impl)
}
