package zio.aws.databrew.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.databrew.model.primitives.JobRunId
import scala.jdk.CollectionConverters.*
final case class StopJobRunResponse(runId: JobRunId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.StopJobRunResponse = {
    import StopJobRunResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.StopJobRunResponse
      .builder()
      .runId(JobRunId.unwrap(runId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.StopJobRunResponse.ReadOnly =
    zio.aws.databrew.model.StopJobRunResponse.wrap(buildAwsValue())
}
object StopJobRunResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.StopJobRunResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.StopJobRunResponse =
      zio.aws.databrew.model.StopJobRunResponse(runId)
    def runId: JobRunId
    def getRunId: ZIO[Any, Nothing, JobRunId] = ZIO.succeed(runId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.StopJobRunResponse
  ) extends zio.aws.databrew.model.StopJobRunResponse.ReadOnly {
    override val runId: JobRunId =
      zio.aws.databrew.model.primitives.JobRunId(impl.runId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.StopJobRunResponse
  ): zio.aws.databrew.model.StopJobRunResponse.ReadOnly = new Wrapper(impl)
}
