package zio.aws.databrew.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.databrew.model.primitives.{BucketOwner, Key, Bucket}
import scala.jdk.CollectionConverters.*
final case class S3Location(
    bucket: Bucket,
    key: Optional[Key] = Optional.Absent,
    bucketOwner: Optional[BucketOwner] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.S3Location = {
    import S3Location.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.S3Location
      .builder()
      .bucket(Bucket.unwrap(bucket): java.lang.String)
      .optionallyWith(key.map(value => Key.unwrap(value): java.lang.String))(
        _.key
      )
      .optionallyWith(
        bucketOwner.map(value => BucketOwner.unwrap(value): java.lang.String)
      )(_.bucketOwner)
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.S3Location.ReadOnly =
    zio.aws.databrew.model.S3Location.wrap(buildAwsValue())
}
object S3Location {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.S3Location
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.S3Location =
      zio.aws.databrew.model.S3Location(
        bucket,
        key.map(value => value),
        bucketOwner.map(value => value)
      )
    def bucket: Bucket
    def key: Optional[Key]
    def bucketOwner: Optional[BucketOwner]
    def getBucket: ZIO[Any, Nothing, Bucket] = ZIO.succeed(bucket)
    def getKey: ZIO[Any, AwsError, Key] = AwsError.unwrapOptionField("key", key)
    def getBucketOwner: ZIO[Any, AwsError, BucketOwner] =
      AwsError.unwrapOptionField("bucketOwner", bucketOwner)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.S3Location
  ) extends zio.aws.databrew.model.S3Location.ReadOnly {
    override val bucket: Bucket =
      zio.aws.databrew.model.primitives.Bucket(impl.bucket())
    override val key: Optional[Key] = zio.aws.core.internal
      .optionalFromNullable(impl.key())
      .map(value => zio.aws.databrew.model.primitives.Key(value))
    override val bucketOwner: Optional[BucketOwner] = zio.aws.core.internal
      .optionalFromNullable(impl.bucketOwner())
      .map(value => zio.aws.databrew.model.primitives.BucketOwner(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.S3Location
  ): zio.aws.databrew.model.S3Location.ReadOnly = new Wrapper(impl)
}
