package zio.aws.databrew.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.databrew.model.primitives.NextToken
import scala.jdk.CollectionConverters.*
final case class ListRulesetsResponse(
    rulesets: Iterable[zio.aws.databrew.model.RulesetItem],
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.ListRulesetsResponse = {
    import ListRulesetsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.ListRulesetsResponse
      .builder()
      .rulesets(rulesets.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.ListRulesetsResponse.ReadOnly =
    zio.aws.databrew.model.ListRulesetsResponse.wrap(buildAwsValue())
}
object ListRulesetsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.ListRulesetsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.ListRulesetsResponse =
      zio.aws.databrew.model.ListRulesetsResponse(
        rulesets.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def rulesets: List[zio.aws.databrew.model.RulesetItem.ReadOnly]
    def nextToken: Optional[NextToken]
    def getRulesets
        : ZIO[Any, Nothing, List[zio.aws.databrew.model.RulesetItem.ReadOnly]] =
      ZIO.succeed(rulesets)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.ListRulesetsResponse
  ) extends zio.aws.databrew.model.ListRulesetsResponse.ReadOnly {
    override val rulesets: List[zio.aws.databrew.model.RulesetItem.ReadOnly] =
      impl
        .rulesets()
        .asScala
        .map { item =>
          zio.aws.databrew.model.RulesetItem.wrap(item)
        }
        .toList
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.databrew.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.ListRulesetsResponse
  ): zio.aws.databrew.model.ListRulesetsResponse.ReadOnly = new Wrapper(impl)
}
